VERSION 5.00
Object = "{831FDD16-0C5C-11D2-A9FC-0000F8754DA1}#2.1#0"; "MSCOMCTL.OCX"
Object = "{F9043C88-F6F2-101A-A3C9-08002B2F49FB}#1.2#0"; "COMDLG32.OCX"
Begin VB.Form frmDPC_Import 
   Caption         =   "Import Prices"
   ClientHeight    =   7860
   ClientLeft      =   60
   ClientTop       =   450
   ClientWidth     =   13365
   ControlBox      =   0   'False
   LinkTopic       =   "Form2"
   ScaleHeight     =   7860
   ScaleWidth      =   13365
   StartUpPosition =   3  'Windows Default
   Begin Project1.ArmCombobox cbo_Vendor 
      Height          =   345
      Left            =   10320
      TabIndex        =   43
      Top             =   3840
      Width           =   1815
      _ExtentX        =   3201
      _ExtentY        =   609
   End
   Begin Project1.ArmCombobox cbo_Destination 
      Height          =   345
      Left            =   2040
      TabIndex        =   42
      Top             =   3840
      Width           =   2535
      _ExtentX        =   4471
      _ExtentY        =   609
   End
   Begin VB.Frame fra_PanelDetails 
      Height          =   1815
      Left            =   360
      TabIndex        =   28
      Top             =   1920
      Width           =   11775
      Begin VB.TextBox txt_Thicknes 
         Height          =   375
         Left            =   7200
         TabIndex        =   40
         Top             =   1200
         Width           =   1095
      End
      Begin Project1.ArmCombobox cbo_SysCat 
         Height          =   345
         Left            =   1560
         TabIndex        =   30
         Tag             =   "sct_idsct_name"
         Top             =   240
         Width           =   3135
         _ExtentX        =   5530
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_System 
         Height          =   345
         Left            =   7200
         TabIndex        =   32
         Tag             =   "sys_idsys_name"
         Top             =   240
         Width           =   2895
         _ExtentX        =   5106
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_Product 
         Height          =   345
         Left            =   1560
         TabIndex        =   34
         Top             =   720
         Width           =   4095
         _ExtentX        =   7223
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_ProductPar 
         Height          =   345
         Left            =   7200
         TabIndex        =   36
         Top             =   720
         Width           =   3975
         _ExtentX        =   4471
         _ExtentY        =   609
      End
      Begin Project1.ArmCombobox cbo_Material 
         Height          =   345
         Left            =   1560
         TabIndex        =   38
         Tag             =   "mat_idmat_name"
         Top             =   1200
         Width           =   2175
         _ExtentX        =   3836
         _ExtentY        =   609
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Thiscknes"
         Height          =   255
         Index           =   10
         Left            =   5760
         TabIndex        =   39
         Top             =   1320
         Width           =   1335
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Material"
         Height          =   255
         Index           =   8
         Left            =   120
         TabIndex        =   37
         Top             =   1320
         Width           =   1455
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Product Par"
         Height          =   255
         Index           =   9
         Left            =   5760
         TabIndex        =   35
         Top             =   720
         Width           =   1215
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Select Product"
         Height          =   255
         Index           =   7
         Left            =   120
         TabIndex        =   33
         Tag             =   "lbl_Prd_Par"
         Top             =   840
         Width           =   1455
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Select System"
         Height          =   255
         Index           =   6
         Left            =   5760
         TabIndex        =   31
         Tag             =   "lbl_Sel_Sys"
         Top             =   240
         Width           =   1335
      End
      Begin VB.Label lbl_Label 
         Caption         =   "#Select Category"
         Height          =   255
         Index           =   0
         Left            =   120
         TabIndex        =   29
         Tag             =   "lbl_Sel_Cat"
         Top             =   360
         Width           =   1455
      End
   End
   Begin Project1.ArmCombobox cbo_ImportType 
      Height          =   345
      Left            =   9360
      TabIndex        =   26
      Top             =   1440
      Width           =   2535
      _ExtentX        =   4471
      _ExtentY        =   609
   End
   Begin VB.TextBox txt_QtyMax 
      Height          =   375
      Left            =   10320
      TabIndex        =   23
      Tag             =   "PRC_QMax"
      Text            =   "10000"
      Top             =   4800
      Width           =   1095
   End
   Begin VB.TextBox txt_QtyMin 
      Height          =   375
      Left            =   6120
      TabIndex        =   22
      Tag             =   "PRC_QMin"
      Text            =   "0"
      Top             =   4800
      Width           =   1095
   End
   Begin MSComctlLib.ProgressBar prb_Progress 
      Height          =   255
      Left            =   3240
      TabIndex        =   16
      Top             =   5280
      Width           =   4695
      _ExtentX        =   8281
      _ExtentY        =   450
      _Version        =   393216
      Appearance      =   1
   End
   Begin VB.TextBox txt_CoSid 
      Height          =   375
      Left            =   12600
      TabIndex        =   15
      Top             =   2400
      Visible         =   0   'False
      Width           =   495
   End
   Begin VB.CheckBox chk_IsPrf 
      Height          =   375
      Left            =   12600
      TabIndex        =   14
      Top             =   2880
      Visible         =   0   'False
      Width           =   495
   End
   Begin VB.TextBox txt_GaCnt 
      Height          =   375
      Left            =   12600
      TabIndex        =   13
      Top             =   1920
      Visible         =   0   'False
      Width           =   495
   End
   Begin Project1.ArmGrid grd_PriceImport 
      Height          =   2055
      Left            =   360
      TabIndex        =   12
      Top             =   5640
      Width           =   12495
      _ExtentX        =   22040
      _ExtentY        =   3625
   End
   Begin Project1.A_calocx cal_EndV 
      Height          =   375
      Left            =   10320
      TabIndex        =   10
      Top             =   4320
      Width           =   1815
      _ExtentX        =   3201
      _ExtentY        =   661
   End
   Begin Project1.A_calocx cal_StartV 
      Height          =   375
      Left            =   6120
      TabIndex        =   8
      Top             =   4320
      Width           =   1815
      _ExtentX        =   3201
      _ExtentY        =   661
   End
   Begin VB.TextBox txt_TableStart 
      Height          =   285
      Left            =   6960
      TabIndex        =   6
      Text            =   "24"
      Top             =   1440
      Width           =   615
   End
   Begin Project1.ArmCombobox cbo_Sheets 
      Height          =   345
      Left            =   2040
      TabIndex        =   4
      Top             =   1440
      Width           =   3135
      _ExtentX        =   5530
      _ExtentY        =   609
   End
   Begin VB.CommandButton cmd_Browse 
      Caption         =   "..."
      Height          =   375
      Left            =   10680
      TabIndex        =   2
      Top             =   960
      Width           =   855
   End
   Begin VB.TextBox txt_ExcelFileName 
      Enabled         =   0   'False
      Height          =   375
      Left            =   2040
      TabIndex        =   1
      Top             =   960
      Width           =   8415
   End
   Begin Project1.ToolbarControl tlb_Main 
      Height          =   690
      Left            =   240
      TabIndex        =   11
      Tag             =   "2929"
      Top             =   120
      Width           =   12975
      _ExtentX        =   22886
      _ExtentY        =   1217
   End
   Begin MSComDlg.CommonDialog dlg_Common 
      Left            =   12360
      Top             =   960
      _ExtentX        =   847
      _ExtentY        =   847
      _Version        =   393216
   End
   Begin Project1.ArmCombobox cbo_Countries 
      Height          =   345
      Left            =   6120
      TabIndex        =   18
      Tag             =   "CT_CodeCT_Desc"
      Top             =   3840
      Width           =   2175
      _ExtentX        =   3836
      _ExtentY        =   609
   End
   Begin Project1.ArmCombobox cbo_Currency 
      Height          =   345
      Left            =   2040
      TabIndex        =   20
      Tag             =   "CURR_CodeCURR_Code"
      Top             =   4800
      Width           =   2535
      _ExtentX        =   4471
      _ExtentY        =   609
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Vendor"
      Height          =   255
      Index           =   11
      Left            =   8640
      TabIndex        =   44
      Tag             =   "lbl_Vendor"
      Top             =   3960
      Width           =   1455
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Destination"
      Height          =   255
      Index           =   12
      Left            =   360
      TabIndex        =   41
      Tag             =   "lbl_Dest"
      Top             =   3960
      Width           =   1575
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Import Type"
      Height          =   255
      Index           =   15
      Left            =   7920
      TabIndex        =   27
      Tag             =   "lbl_Import_Type"
      Top             =   1560
      Width           =   1335
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Qty Max"
      Height          =   255
      Index           =   86
      Left            =   8640
      TabIndex        =   25
      Tag             =   "lbl_QtyMax"
      Top             =   4920
      Width           =   975
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Qty Min"
      Height          =   255
      Index           =   89
      Left            =   4680
      TabIndex        =   24
      Tag             =   "lbl_QtyMin"
      Top             =   4920
      Width           =   975
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#CURR Code"
      Height          =   255
      Index           =   80
      Left            =   360
      TabIndex        =   21
      Tag             =   "lbl_CURR_Code"
      Top             =   4800
      Width           =   1215
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#CT_code"
      Height          =   255
      Index           =   202
      Left            =   4680
      TabIndex        =   19
      Tag             =   "lbl_CT_Code"
      Top             =   3960
      Width           =   1215
   End
   Begin VB.Label lbl_ProgressMsg 
      Caption         =   "Import:"
      Height          =   255
      Left            =   360
      TabIndex        =   17
      Top             =   5280
      Width           =   2775
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Validity End"
      Height          =   255
      Index           =   5
      Left            =   8640
      TabIndex        =   9
      Tag             =   "lbl_Val_End"
      Top             =   4440
      Width           =   1455
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Validity Start"
      Height          =   255
      Index           =   4
      Left            =   4680
      TabIndex        =   7
      Tag             =   "lbl_Val_Start"
      Top             =   4440
      Width           =   1335
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Table starting cell:"
      Height          =   255
      Index           =   3
      Left            =   5280
      TabIndex        =   5
      Tag             =   "lbl_Start_Cell"
      Top             =   1560
      Width           =   1695
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Sheet to import:"
      Height          =   255
      Index           =   2
      Left            =   360
      TabIndex        =   3
      Tag             =   "lbl_Select_Sheet"
      Top             =   1560
      Width           =   1575
   End
   Begin VB.Label lbl_Label 
      Caption         =   "#Select Excel File:"
      Height          =   255
      Index           =   1
      Left            =   360
      TabIndex        =   0
      Tag             =   "lbl_Select_File"
      Top             =   1080
      Width           =   1575
   End
End
Attribute VB_Name = "frmDPC_Import"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Declare Sub CopyMemory Lib "Kernel32" Alias "RtlMoveMemory" (ByVal dst As Long, ByVal src As Long, ByVal nBytes As Long)
Private Declare Function LockWindowUpdate Lib "user32" (ByVal hwnd As Long) As Long

Private Const SEP = ""
Private Const C_SEP As String = "@@"
Private Const SEP1 As String = ""
Private Const SEP2 As String = ""
Private Const CL_COLOR_ENABLED As Long = &H80000005
Private Const CL_COLOR_DISABLED As Long = &H8000000F
Private Const SCREEN_NAME As String = "frmDPC_Import"
Private Const SW_SHOWNORMAL = 1

Private Const LOCALE_SDECIMAL = &HE ' Decimal separator
Private Const LOCALE_STHOUSAND = &HF ' Thousand separator
Private Const LOCALE_USER_DEFAULT = &H400
Private Const C_ERRORRAISE As Long = 2500
Private Const C_MSG_ID_BASE As Long = 9800

#If ENV = LIVE Then
Private mo_Sys As Object
Private mo_Db As Object
Private mo_FSO As Object
#Else
Private mo_Sys As ARMSYSCOMLib.ArmSYS
Private mo_Db As ARMSYSCOMLib.ArmDb
Private mo_FSO As Scripting.FileSystemObject
#End If

Private mo_Tools As DPC_Tools

Private ml_U_Code As Long
Private mb_Initialized As Boolean
Private ms_DecimalSeparator As String
Private ms_ThousandSeparator As String
Private mc_ScreenLabels As Long
Private mc_Toolbars As Long
Private mo_WshNetwork As Object
Private ms_ComputerName As String
Private ms_Language_Code                As String       'current user interface language
Private ms_LoginName                    As String       'contain loginname
Private ms_UserName                     As String       'contain name of logged user as defined in GEN_People
Private mb_Result As Boolean
Private ml_AgId As Long

Private mb_InternalInit As Boolean

Private Enum ArmErr
    DBCnxFailed = vbObjectError + 1             ' Unable to connect to the database
    CPTAlreadyInitialized = vbObjectError + 2   ' We try to initialize a component that is already initialized
    CPTNotInitialized = vbObjectError + 3       ' We try to use or free that is not initialized yet
    InvalidArgument = vbObjectError + 4
    PropertyNotSet = vbObjectError + 5
    SQLFailure = vbObjectError + 6               ' A SQL runtime error has occured : syntax wrong....
    SQLBadRowAffectedCount = vbObjectError + 7   ' A SQL request has not affected the expected rowcount (ex: one Update do nothing)
    SQLBadRowExpectedCount = vbObjectError + 8   ' A SQL request does not return the expected rowcount : select an item return nothing...
    DrivingError = vbObjectError + 9
    CompFncFailed = vbObjectError + 10           ' when component function fail
    GridLoadFailed = vbObjectError + 11          ' load function failed ... bad sql
    QuietException = vbObjectError + 12          ' do not display error message
    SQLTableReferenceConstraint = vbObjectError + 13 ' A SQL request cannot be executed : Table reference constraint
    DuplicityDetected = vbObjectError + 2301     ' detected row with same unique id
End Enum

Private Type tExcelImported
    Count As Long
    InsertedCountPrices As Long
    UpdatedCountPrices As Long
    DeletedCountPrices As Long
    InsertedCountPriceCrits As Long
    FileName As String
End Type

Private Type tPrice
    PRD_Id As String
    PCR_Id As Long
    CT_Code As String
    CURR_Code As String
    'UM_CodeQ As String
    UM_CodeC As String
    QMin As Double
    QMax As Double
    VStart As Date
    VExp As Date
    Cost As Double
    CatIdx As Long
End Type

Private Type tPriceCrit
    PCR_Id As Long
    PRD_Id As String
    PRD_IdPar As String
    CUA_Id As Long
    PCR_AMin As Double
    PCR_AMax As Double
    PCR_BMin As Double
    PCR_BMax As Double
    MAT_Id As Long
    PCR_Thick As Double
    PCR_TMin As Double
    PCR_TMax As Double
    PCR_IsPrf As Boolean
    PCR_GaCnt As Integer
    PCR_CoSid As Integer
    CatIdx As Long
    Cost As Double
    QMin As Double
    QMax As Double
    AlreadyInserted As Boolean
    UM_CodeC As String
End Type

Private Type tProductInfo
    PRD_Id As String
    AMin As Double
    AMax As Double
    BMin As Double
    BMax As Double
End Type

Private Enum eImportType
    itFixed = 1
    itBended = 2
End Enum

Private Enum eImportDest
    idPrice = 1
    idCost = 2
End Enum

Dim mt_ImportType As eImportType
Dim mt_ImportDest As eImportDest

Dim ml_NrOfMainProducts As Long
Dim ml_CurrCategory As Long
Dim ms_CurrCategoryDesc As String

Dim mt_ProductInfo() As tProductInfo

Dim md_LastUpdated As Date

'Excel column names definitions
Private Const EX_PCR_AMin = 2
Private Const EX_PCR_AMax = 4

Private Const CONST_PRODUCT_REQUEST = "Select prd.prd_id,  des.prd_name + ' (' + prd.prd_code + ')' as PRD_Name from dpc_prdcommon prd " & _
                          "inner join dpc_prddesc des on prd.prd_id = des.prd_id and des.language_code = $Language_Code$" & _
                          "Where prd.CAT_Id = 22"
                          
Private Const CONST_PRODUCT_REQUEST_2 = "Select prd.prd_id, des.prd_name + ' (' + prd.prd_code + ')' as PRD_Name from dpc_prdcommon prd " & _
                          "inner join dpc_prddesc des on prd.prd_id = des.prd_id and des.language_code = $Language_Code$" & _
                          "inner join dpc_rectpanel rct on prd.prd_id = rct.rpl_id and rct.sys_id = $SYS_ID$ " & _
                          "Where prd.CAT_Id = 22"
                          
Private mt_PriceCritForCategory() As tPriceCritForCategory

Property Let PriceCritForCategory(al_Col As Collection)
    Dim ll_Index As Long
    
    ReDim mt_PriceCritForCategory(al_Col.Count)
    
    For ll_Index = 0 To al_Col.Count - 1
        'mt_PriceCritForCategory(ll_Index) = al_col.Item(ll_Index)
        CopyMemory VarPtr(mt_PriceCritForCategory(ll_Index)), al_Col.Item(Str(ll_Index)), Len(mt_PriceCritForCategory(ll_Index))
    Next
    'CopyMemory VarPtr(mt_PriceCritForCategory), ArgUdtPtr, Len(mt_PriceCritForCategory)
    'mt_PriceCritForCategory = lPriceCrit
End Property

Property Let Language_Code(AString As String)
  ms_Language_Code = AString
End Property

Property Let CurrCategory(al_CurrCategory As Long)
  ml_CurrCategory = al_CurrCategory
End Property

Property Let CurrCategoryDesc(as_CurrCategory As String)
  ms_CurrCategoryDesc = as_CurrCategory
End Property

Property Get Language_Code() As String
  Language_Code = ms_Language_Code
End Property

Public Property Set ArmDb(ByRef lo_Db As Object)
  If Not (lo_Db Is Nothing) Then
      Set mo_Db = lo_Db
  End If
End Property

Property Let U_Code(al_Code As Long)
  ml_U_Code = al_Code
End Property

Public Property Set Tools(ByRef ao_Tools As Object)
On Error GoTo ErrorHandler

  Set mo_Tools = ao_Tools
  Exit Property
ErrorHandler:
  Call ErrorHandler("Tools.Set")
End Property

Public Property Get Result() As Boolean
  Result = mb_Result
End Property

Public Function Load_A_COM() As Boolean
On Error GoTo ErrHandler

Dim ll_Index As Long
Dim lo_Control As Object
Dim la_Columns As Variant
    
  Load_A_COM = False
  
  If mo_Db Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
  If mo_Tools Is Nothing Then
      Call Err.Raise(ArmErr.PropertyNotSet)
  End If
    
  If mb_Initialized Then
      Call Err.Raise(ArmErr.CPTAlreadyInitialized)
  End If
  
  mb_InternalInit = False
  
  Call mo_Tools.Load_A_ComControls(Me.Controls, mo_Db, ms_Language_Code)
  
  ms_ThousandSeparator = mo_Tools.GetLocaleInfo(LOCALE_USER_DEFAULT, LOCALE_STHOUSAND)
  ms_DecimalSeparator = Format(0, ".")
  mc_Toolbars = 0
  
  Set mo_FSO = CreateObject("Scripting.FileSystemObject")
  
#If ENV = LIVE Then
  Set mo_Sys = CreateObject("ArmSYSCOM.ArmSys")
#Else
  Set mo_Sys = New ARMSYSCOMLib.ArmSYS
#End If
  
  Set mo_WshNetwork = CreateObject("WScript.Network")
  ms_ComputerName = mo_WshNetwork.ComputerName
    
  'Call tlb_Main.SetToolbarInfoStringParameters("001EE01760QESFGIDR/BACAHHFLLSTT", "001")
  'Call tlb_Main.DisplayFace("0")
  'tlb_Main.Visible = True

  Call mo_Tools.LoadToolbars(mo_Db, Me.Controls, "DPC_Ref", SCREEN_NAME)
  'Screen csts
  mc_ScreenLabels = mo_Tools.LoadLabels(mo_Db, Me.Controls, Me, SCREEN_NAME, ms_Language_Code)
  Call mo_Tools.ChangeCharset(Me.Controls, mo_Tools.GetCodePageFromLanguage(mo_Db, ms_Language_Code), mo_Tools.GetCodePageFromLanguage(mo_Db, ms_Language_Code), Me)
    
    Call cbo_ImportType.AddItem(Array(eImportType.itFixed, "Fixed"))
    Call cbo_ImportType.AddItem(Array(eImportType.itBended, "Bended"))
    Call cbo_ImportType.SearchItem(eImportType.itFixed, 0)
    mt_ImportType = eImportType.itFixed
    Call cbo_ImportType_ComboItemSelected
    
    Call cbo_Destination.AddItem(Array(eImportDest.idPrice, "DPC_Price"))
    Call cbo_Destination.AddItem(Array(eImportDest.idCost, "DPC_Cost"))
    Call cbo_Destination.SearchItem(eImportDest.idPrice, 0)
    mt_ImportDest = eImportDest.idPrice
    Call cbo_Destination_ComboItemSelected
    
    cbo_SysCat.Request = "exec dpc_syscategories_lst $Language_code$"
    cbo_SysCat.Request = Replace(cbo_SysCat.Request, "$Language_code$", mo_Tools.SqlStr(tlb_Main.Language), , , vbTextCompare)
    cbo_SysCat.Load
        
    cbo_Product.Request = CONST_PRODUCT_REQUEST
    cbo_Product.Request = Replace(cbo_Product.Request, "$Language_code$", mo_Tools.SqlStr(tlb_Main.Language), , , vbTextCompare)
    cbo_Product.Load
    
    cbo_ProductPar.Request = Replace(cbo_Product.Request, "$Language_code$", mo_Tools.SqlStr(tlb_Main.Language), , , vbTextCompare)
    cbo_ProductPar.Load
    
    cbo_Vendor.Request = "exec DPC_Vendor_lst"
    cbo_Vendor.Load
    Call cbo_Vendor.SearchItem("2")
    
    cbo_Material.Request = "exec dpc_material_lst2 $Language_code$"
    cbo_Material.Request = Replace(cbo_Material.Request, "$Language_code$", mo_Tools.SqlStr(tlb_Main.Language), , , vbTextCompare)
    cbo_Material.Load
    Call cbo_Material.SearchItem("1")
    
    grd_PriceImport.SetColumns (Array( _
        "MSG_Id01MSG_Id#MSG_Id", _
        "MSG_Text90000MSG_Text#MSG_Text"))
        
    cbo_Countries.Request = "exec countries_cbo $Language_code$"
    cbo_Countries.Request = Replace(cbo_Countries.Request, "$Language_code$", mo_Tools.SqlStr(tlb_Main.Language), , , vbTextCompare)
    cbo_Countries.Load
    Call cbo_Countries.SearchItem("GB")
    
    cbo_Currency.Request = "exec currencies_cbo $Language_code$"
    cbo_Currency.Request = Replace(cbo_Currency.Request, "$Language_code$", mo_Tools.SqlStr(tlb_Main.Language), , , vbTextCompare)
    cbo_Currency.Load
    Call cbo_Currency.SearchItem("EUR")

    cal_StartV.date_courte = Format(DateSerial(Year(Now), Month(Now) + 1, 1), "dd\/mm\/yyyy")
    cal_StartV.Zorder
    
    cal_EndV.date_courte = Format(DateSerial(Year(Now) + 1, Month(Now), 31), "dd\/mm\/yyyy")
    cal_EndV.Zorder

    If ml_CurrCategory = eDPCCategory.cgPerforation Or _
       ml_CurrCategory = eDPCCategory.cgCoating Or _
       ml_CurrCategory = eDPCCategory.cgGasket Or _
       ml_CurrCategory = eDPCCategory.cgInlay Or _
       ml_CurrCategory = eDPCCategory.cgPacking Or _
       ml_CurrCategory = eDPCCategory.cgSurcharge Or _
       ml_CurrCategory = eDPCCategory.cgSubconstructionArticle Then
       
       cbo_ImportType.Enabled = False
       
       fra_PanelDetails.Visible = False
       lbl_Label(89).Visible = False
       txt_QtyMin.Visible = False
       lbl_Label(86).Visible = False
       txt_QtyMax.Visible = False
    
    ElseIf ml_CurrCategory = eDPCCategory.cgMetalCustomPanelTemplate Then
    Else
        Load_A_COM = False
        Exit Function
    End If
    
  mb_Result = False
  mb_Initialized = True
  Load_A_COM = mb_Initialized
  Exit Function
ErrHandler:
  Call ErrorMessage("Load_A_COM")
End Function

Public Function Unload_A_COM() As Boolean
On Error GoTo ErrHandler

  Call mo_Tools.Unload_A_ComControls(Me.Controls)
  Call mo_Db.Close(mc_ScreenLabels)
  Set mo_Sys = Nothing
  Set mo_FSO = Nothing
  Set mo_Db = Nothing
  Set mo_Tools = Nothing
  
  Exit Function
ErrHandler:
  Call ErrorMessage("Unload_A_COM")
End Function

Private Sub cbo_Destination_ComboItemSelected()
On Error GoTo ErrHandler

    mt_ImportDest = cbo_Destination.SelectedItem.Key

    If mt_ImportDest = eImportDest.idPrice Then
        cbo_Vendor.Enabled = False
        cbo_Countries.Enabled = True
    Else
        cbo_Vendor.Enabled = True
        cbo_Countries.Enabled = False
    End If
    
  Exit Sub
ErrHandler:
  Call ErrorMessage("cbo_Destination_ComboItemSelected")
End Sub

Private Sub cbo_ImportType_ComboItemSelected()
On Error GoTo ErrHandler

    mt_ImportType = cbo_ImportType.SelectedItem.Key

    If mt_ImportType = itFixed Then
        cbo_SysCat.Enabled = False
        cbo_System.Enabled = False
        cbo_Product.Enabled = False
        cbo_ProductPar.Enabled = False
        
    Else
        cbo_SysCat.Enabled = True
        cbo_System.Enabled = True
        cbo_Product.Enabled = True
        cbo_ProductPar.Enabled = True
        
    End If
    
  Exit Sub
ErrHandler:
  Call ErrorMessage("cbo_ImportType_ComboItemSelected")
End Sub

Private Sub cbo_Product_ComboItemSelected()
On Error GoTo ErrHandler

    Call cbo_ProductPar.SearchItem(cbo_Product.SelectedItem.Key)
    
  Exit Sub
ErrHandler:
  Call ErrorMessage("cbo_Product_ComboItemSelected")
End Sub

Private Sub cbo_SysCat_ComboItemSelected()
On Error GoTo ErrHandler
  
    cbo_System.Request = "exec dpc_system_lst2 $Language_code$, $SCT_Id$"
    cbo_System.Request = Replace(cbo_System.Request, "$Language_code$", mo_Tools.SqlStr(tlb_Main.Language), , , vbTextCompare)
    cbo_System.Request = Replace(cbo_System.Request, "$SCT_Id$", mo_Tools.SqlIntKey(cbo_SysCat.SelectedItem.Key), , , vbTextCompare)
    cbo_SysCat.Load
  
  Exit Sub
ErrHandler:
  Call ErrorMessage("cbo_SysCat_ComboItemSelected")
End Sub

Private Sub cbo_System_ComboItemSelected()
    
    cbo_Product.Request = CONST_PRODUCT_REQUEST_2
    cbo_Product.Request = mo_Tools.ReplacePlaceHolder(cbo_Product.Request, "$SYS_Id$", mo_Tools.SqlIntKey(cbo_System.SelectedItem.Key))
    cbo_Product.Request = Replace(cbo_Product.Request, "$Language_code$", mo_Tools.SqlStr(tlb_Main.Language), , , vbTextCompare)
    cbo_Product.Load

End Sub

Private Sub cmd_Browse_Click()
On Error GoTo ErrHandler

Dim ls_filePath As String

    dlg_Common.Filter = "XLS files (*.xlsx)|*.xlsx"
    dlg_Common.CancelError = False
    Call dlg_Common.ShowOpen
    
    If dlg_Common.FileName <> "" Then
        
        txt_ExcelFileName.Text = dlg_Common.FileName
            
        Call mo_Tools.LockScreen(Me, True)

        Call InitSheetCombo(txt_ExcelFileName.Text)
        
        Call mo_Tools.LockScreen(Me, False)
        
'        Call Process_File(ls_filePath, la_MainConfigIndex)
    End If
  Exit Sub
ErrHandler:
  Call ErrorMessage("cmd_Browse_Click")
End Sub

Private Sub tlb_Main_action(ByVal as_Role As String, as_Language As String)
On Error GoTo ErrHandler

  Call mo_Tools.LockScreen(Me, True)
  Select Case as_Role
  Case "H"
    'If ml_AgId = 0 Then
    '  Call mo_Tools.LockScreen(Me, False)
    '  Exit Sub
    'End If
    mb_Result = True
    Hide
  Case "L"
    If ImportPrice = False Then
        Call ProgressBarLabel(mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 10, "#Finished with error."))
    End If
    'Call RefreshGrid
  Case "T"
    mb_Result = False
    Hide
  End Select
  Call mo_Tools.LockScreen(Me, False)
  Exit Sub
ErrHandler:
  Call ErrorMessage("tlb_Main_action")
End Sub

Private Function InitSheetCombo(ByVal as_filePath As String)
On Error GoTo ErrHandler

Dim ll_Idx As Long

#If LIVE = 1 Then
    Dim lo_XLApp As Object   ' Excel.Application
    Dim lo_XLBook As Object  ' Excel.Workbook
#Else
    Dim lo_XLApp As Excel.Application
    Dim lo_XLBook As Excel.Workbook
#End If
    
    Set lo_XLApp = CreateObject("Excel.Application")
    Set lo_XLBook = lo_XLApp.Workbooks.Open(as_filePath)
    
    If lo_XLBook Is Nothing Then
        'Call LogMessage("ImportExcelFile, Export Workbook not available in source xls file:" & as_filePath)
        Exit Function
    End If
    
    Call cbo_Sheets.Clear
    
    For ll_Idx = 1 To lo_XLBook.Worksheets.Count
        Call cbo_Sheets.AddItem(Array(ll_Idx, lo_XLBook.Worksheets(ll_Idx).Name))
    Next
               
    lo_XLApp.Workbooks(1).Close (False)
    
    Set lo_XLBook = Nothing
    Set lo_XLApp = Nothing

    Exit Function
ErrHandler:
    Call ErrorHandler("InitSheetCombo")
End Function

Private Sub ProgressBarShow(ByVal al_max As Long)
On Error GoTo ErrHandler
    
    'LockWindowUpdate 0
    
    prb_Progress.Max = al_max
    prb_Progress.Value = 0
    Exit Sub
ErrHandler:
    Call ErrorHandler("ProgressBarShow")
End Sub

Private Sub ProgressBarStep()
On Error GoTo ErrHandler
    prb_Progress.Value = prb_Progress.Value + 1
    DoEvents
    If DateDiff("s", md_LastUpdated, Now) > 5 Then
        md_LastUpdated = Now()
        Refresh
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler("ProgressBarStep")
End Sub

Private Sub ProgressBarLabel(ByVal as_Msg As String)
On Error GoTo ErrHandler
    lbl_ProgressMsg.Caption = as_Msg
    lbl_ProgressMsg.Refresh
    Exit Sub
ErrHandler:
    Call ErrorHandler("ProgressBarLabel")
End Sub

Private Sub ProgressBarHide()
On Error GoTo ErrHandler
    prb_Progress.Value = 0
    Exit Sub
ErrHandler:
    Call ErrorHandler("ProgressBarHide")
End Sub

Private Function ImportPrice()

Const SQL_PRICE_INS = "exec DPC_Price_ins $PRC_Id$,$PCR_Id$,$PRD_Id$,$CT_Code$,$CURR_Code$,$PRC_VStart$,$PRC_VExp$,$PRC_QMin$,$PRC_QMax$,$UM_CodeQ$,$PRC_Cost$,$UM_CodeC$,$U_Code$"
Const SQL_PRICE_UPD = "exec DPC_Price_upd $PRC_Id$,$PCR_Id$,$PRD_Id$,$CT_Code$,$CURR_Code$,$PRC_VStart$,$PRC_VExp$,$PRC_QMin$,$PRC_QMax$,$UM_CodeQ$,$PRC_Cost$,$UM_CodeC$,$U_Code$,$iConcurrency$"
Const SQL_PRICE_DEL = "exec DPC_Price_del $PRC_Id$,$U_Code$,$iConcurrency$"
Const SQL_PRICE_CHECK = "exec DPC_Price_chk $PRD_Id$,$PCR_Id$,$CT_Code$,$CURR_Code$,$UM_CodeQ$,$PRC_VStart$,$PRC_VExp$,$QMin$,$QMax$,$UM_CodeC$"

Const SQL_PRICE_CRIT_INS = "exec DPC_PriceCrit_ins $PCR_Id$,$PRD_Id$,$PRD_IdPar$,$CUA_Id$,$PCR_AMin$,$PCR_AMax$,$PCR_BMin$,$PCR_BMax$,$MAT_Id$,$PCR_Thick$,$PCR_TMin$,$PCR_TMax$,$PCR_IsPrf$,$PCR_GaCnt$,$PCR_CoSid$,$U_Code$"

Const SQL_COST_INS = "exec DPC_Cost_ins $PRC_Id$,$PCR_Id$,$PRD_Id$,$VEN_Id$,$CURR_Code$,$PRC_VStart$,$PRC_VExp$,$PRC_QMin$,$PRC_QMax$,$UM_CodeQ$,$PRC_Cost$,$UM_CodeC$,$U_Code$"
Const SQL_COST_UPD = "exec DPC_Cost_upd $PRC_Id$,$PCR_Id$,$PRD_Id$,$VEN_Id$,$CURR_Code$,$PRC_VStart$,$PRC_VExp$,$PRC_QMin$,$PRC_QMax$,$UM_CodeQ$,$PRC_Cost$,$UM_CodeC$,$U_Code$,$iConcurrency$"
Const SQL_COST_DEL = "exec DPC_Cost_upd $PRC_Id$,$U_Code$,$iConcurrency$"
Const SQL_COST_CHECK = "exec DPC_Cost_chk $PRD_Id$,$PCR_Id$,$VEN_Id$,$CURR_Code$,$UM_CodeQ$,$PRC_VStart$,$PRC_VExp$,$QMin$,$QMax$,$UM_CodeC$"

On Error GoTo ErrHandler

Dim lt_PriceInfoCommon As tPrice
Dim lt_PriceCritInfoCommon As tPriceCrit
Dim lt_ExcelImported As tExcelImported
Dim ls_Request, ls_CommonRequest As String
Dim ls_PriceCommonRequest As String
Dim ll_Cursor As Long
Dim lt_PriceInfo() As tPrice
Dim lt_PriceCritInfo() As tPriceCrit
Dim ll_Index As Integer
Dim ll_CatIndex As Long
Dim ll_PCR_Id As Long
Dim lv_Info(3) As String

#If LIVE = 1 Then
    Dim lo_XLApp As Object   ' Excel.Application
    Dim lo_XLBook As Object  ' Excel.Workbook
    Dim lo_XLSheet As Object ' Excel.Worksheet
#Else
    Dim lo_XLApp As Excel.Application
    Dim lo_XLBook As Excel.Workbook
    Dim lo_XLSheet As Excel.Worksheet
#End If

Dim lngCol As Long, lngRow As Long

Dim lv_DataArray() As Variant
Dim ll_Err As String
Dim ll_DetectionCol As Long

    ImportPrice = False

    If cbo_Sheets.SelectedItem Is Nothing Then
        Call LogGridMsg(mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 36, "#Excel sheet to import not selected"))
        Exit Function
    End If
    
    lv_Info(0) = "%1"
    lv_Info(1) = cbo_Sheets.SelectedItem.DisplayText
    lv_Info(2) = "%2"
    lv_Info(3) = ms_CurrCategoryDesc

    If MsgBox(mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 40, "#Importing %1 into %2?", lv_Info), vbOKCancel, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision) = vbCancel Then
        Exit Function
    End If
    
Set lo_XLApp = CreateObject("Excel.Application")
Set lo_XLBook = lo_XLApp.Workbooks.Open(txt_ExcelFileName.Text)

If lo_XLBook Is Nothing Then
    'Call LogMessage("ImportExcelFile, Export Workbook not available in source xls file:" & as_filePath)
    Exit Function
End If

Set lo_XLSheet = lo_XLBook.Worksheets(cbo_Sheets.SelectedItem.DisplayText)

If lo_XLSheet Is Nothing Then
    'Call LogMessage("ImportExcelFile, Export Worksheet not available in source xls file:" & as_filePath)
    Exit Function
End If

lv_DataArray = lo_XLSheet.UsedRange.Value

    lo_XLApp.Workbooks(1).Close (False)
    
    Set lo_XLSheet = Nothing
    Set lo_XLBook = Nothing
    Set lo_XLApp = Nothing

    lt_ExcelImported.Count = 0
    lt_ExcelImported.InsertedCountPrices = 0
    lt_ExcelImported.UpdatedCountPrices = 0
    lt_ExcelImported.DeletedCountPrices = 0
    lt_ExcelImported.InsertedCountPriceCrits = 0
                                        
    Call ProgressBarShow(UBound(lv_DataArray, 1) + 1)
    Call ProgressBarLabel(mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 7, "#Checking common info from excel ..."))
            
    'Call QuickSort(lv_DataArray, ll_keys, 0, 0)
                
    grd_PriceImport.ClearGrid
    
    ReDim lt_PriceCritInfo(-1 To -1)
    ReDim lt_PriceInfo(-1 To -1)
    ReDim mt_ProductInfo(-1 To -1)
    
    'First check common info required to add PriceCrit for selected product
    'and fill lt_PriceCrit with common data for ongoing import
    If ImportPriceCrit_CommonInfoCheck(lt_PriceCritInfoCommon, ls_CommonRequest, ll_CatIndex, ll_Err) = False Or _
        ImportPrice_CommonInfoCheck(lt_PriceInfoCommon, ls_PriceCommonRequest, ll_Err) = False Then
        
        Call LogGridMsg(ll_Err)
        Exit Function
    End If
        
    ml_NrOfMainProducts = 0
    
    If ml_CurrCategory = eDPCCategory.cgMetalCustomPanelTemplate Or ml_CurrCategory = eDPCCategory.cgMetalPanelSKU Then
        ll_DetectionCol = 2
    Else
        ll_DetectionCol = 9
    End If
        
    'Check TABLE
    If False = Check_Table(lt_PriceCritInfoCommon, lt_PriceCritInfo, lt_PriceInfo, ls_CommonRequest, ls_PriceCommonRequest, CInt(txt_TableStart.Text), lv_DataArray, ms_CurrCategoryDesc, ml_CurrCategory, lt_ExcelImported, ll_DetectionCol) Then
        Exit Function
    End If
    
    If mt_ImportType = eImportType.itFixed Then
        ml_NrOfMainProducts = UBound(lt_PriceCritInfo)
    End If
                
    Call ProgressBarHide
    
    If grd_PriceImport.Rows > 0 Then
        Exit Function
    End If
                            
    On Error GoTo ErrorImportRow
    
    If UBound(lt_PriceCritInfo) > 0 Then
        Call ProgressBarShow(UBound(lt_PriceCritInfo) + 1)
    End If
    Call ProgressBarLabel(mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 8, "#Importing price crits ..."))
    
    For lngRow = 0 To UBound(lt_PriceCritInfo)
                                                                                                                                            
        Call ProgressBarStep
        
        If lt_PriceCritInfo(lngRow).AlreadyInserted = False Then
                                                                                                                                        
            ls_Request = SQL_PRICE_CRIT_INS
            
            ll_CatIndex = FindIndexForCategory(lt_PriceCritInfo(lngRow).CatIdx)
            
            ll_PCR_Id = mo_Tools.GetNextID(mo_Db, "DPC_PriceCrit")
            lt_PriceCritInfo(lngRow).PCR_Id = ll_PCR_Id
            ls_Request = Replace(ls_Request, "$PCR_Id$", mo_Tools.SqlInt(ll_PCR_Id))
            ls_Request = Replace(ls_Request, "$PRD_Id$", mo_Tools.SqlStr(lt_PriceCritInfo(lngRow).PRD_Id), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PRD_IdPar$", IIf(mt_PriceCritForCategory(ll_CatIndex).PRD_IdPar = True, mo_Tools.SqlStr(lt_PriceCritInfo(lngRow).PRD_IdPar), "Null"), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$CUA_Id$", IIf(mt_PriceCritForCategory(ll_CatIndex).CUA_Id = True, mo_Tools.SqlInt(lt_PriceCritInfo(lngRow).CUA_Id), "Null"), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PCR_AMin$", IIf(mt_PriceCritForCategory(ll_CatIndex).PCR_AMin = True, mo_Tools.SqlDbl(lt_PriceCritInfo(lngRow).PCR_AMin), "Null"), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PCR_AMax$", IIf(mt_PriceCritForCategory(ll_CatIndex).PCR_AMax = True, mo_Tools.SqlDbl(lt_PriceCritInfo(lngRow).PCR_AMax), "Null"), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PCR_BMin$", IIf(mt_PriceCritForCategory(ll_CatIndex).PCR_BMin = True, mo_Tools.SqlDbl(lt_PriceCritInfo(lngRow).PCR_BMin), "Null"), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PCR_BMax$", IIf(mt_PriceCritForCategory(ll_CatIndex).PCR_BMax = True, mo_Tools.SqlDbl(lt_PriceCritInfo(lngRow).PCR_BMax), "Null"), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$MAT_Id$", IIf(mt_PriceCritForCategory(ll_CatIndex).MAT_Id = True, mo_Tools.SqlInt(lt_PriceCritInfo(lngRow).MAT_Id), "Null"), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PCR_Thick$", IIf(mt_PriceCritForCategory(ll_CatIndex).PCR_Thick = True, mo_Tools.SqlDbl(lt_PriceCritInfo(lngRow).PCR_Thick), "Null"), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PCR_TMin$", IIf(mt_PriceCritForCategory(ll_CatIndex).PCR_TMin = True, mo_Tools.SqlDbl(lt_PriceCritInfo(lngRow).PCR_TMin), "Null"), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PCR_TMax$", IIf(mt_PriceCritForCategory(ll_CatIndex).PCR_TMax = True, mo_Tools.SqlDbl(lt_PriceCritInfo(lngRow).PCR_TMax), "Null"), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PCR_IsPrf$", IIf(mt_PriceCritForCategory(ll_CatIndex).PCR_IsPrf = True, mo_Tools.SqlBool(lt_PriceCritInfo(lngRow).PCR_IsPrf), "Null"), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PCR_GaCnt$", IIf(mt_PriceCritForCategory(ll_CatIndex).PCR_GaCnt = True, mo_Tools.SqlInt(lt_PriceCritInfo(lngRow).PCR_GaCnt), "Null"), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PCR_CoSId$", IIf(mt_PriceCritForCategory(ll_CatIndex).PCR_CoSid = True, mo_Tools.SqlInt(lt_PriceCritInfo(lngRow).PCR_CoSid), "Null"), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$U_Code$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
            
            Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Request)
            lt_ExcelImported.InsertedCountPriceCrits = lt_ExcelImported.InsertedCountPriceCrits + 1
        Else
            lt_PriceCritInfo(lngRow).PCR_Id = FindPCRForInsertedPriceCrit(lt_PriceCritInfo, lngRow)
        End If
        
        'even if there is no price defined we need to save price info
        'for case that the price needs to be deleted
        If UBound(lt_PriceInfo) = -1 Then
            ReDim lt_PriceInfo(0)
        Else
            ReDim Preserve lt_PriceInfo(UBound(lt_PriceInfo) + 1)
        End If
                
        lt_PriceInfo(UBound(lt_PriceInfo)).PCR_Id = lt_PriceCritInfo(lngRow).PCR_Id
        lt_PriceInfo(UBound(lt_PriceInfo)).Cost = lt_PriceCritInfo(lngRow).Cost
        lt_PriceInfo(UBound(lt_PriceInfo)).QMin = lt_PriceCritInfo(lngRow).QMin
        lt_PriceInfo(UBound(lt_PriceInfo)).QMax = lt_PriceCritInfo(lngRow).QMax
        lt_PriceInfo(UBound(lt_PriceInfo)).PRD_Id = lt_PriceCritInfo(lngRow).PRD_Id
        lt_PriceInfo(UBound(lt_PriceInfo)).CatIdx = lt_PriceCritInfo(lngRow).CatIdx
        lt_PriceInfo(UBound(lt_PriceInfo)).UM_CodeC = lt_PriceCritInfo(lngRow).UM_CodeC
                                            
        GoTo NextImportRow
        'error managment - if import failed, continue to import next row
ErrorImportRow:
        'Call LogMessage("ImportPrice PRD_Id=" & lt_Price.PRD_Id & " Count=" & lt_ExcelImported.Count)
        Call LogGridMsg("ImportPrice PRD_Id=" & lt_PriceCritInfo(lngRow).PRD_Id & " error:" & Err.Description)
        Resume NextImportRow
NextImportRow:
    Next
    
    On Error GoTo ErrorImportPriceRow
    
    If UBound(lt_PriceInfo) > 0 Then
        Call ProgressBarShow(UBound(lt_PriceInfo) + 1)
    End If
    
    Call ProgressBarLabel(mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 9, "#Importing prices ..."))
    
    For lngRow = 0 To UBound(lt_PriceInfo)
                                                                                                                                            
        Call ProgressBarStep
                                                                                                                                            
        If cbo_Destination.SelectedItem.Key = eImportDest.idPrice Then
            ls_Request = SQL_PRICE_CHECK
        Else
            ls_Request = SQL_COST_CHECK
        End If
        
        ls_Request = Replace(ls_Request, "$PRD_Id$", mo_Tools.SqlStr(lt_PriceInfo(lngRow).PRD_Id))
        ls_Request = Replace(ls_Request, "$PCR_Id$", mo_Tools.SqlInt(lt_PriceInfo(lngRow).PCR_Id))
        ls_Request = Replace(ls_Request, "$CT_Code$", mo_Tools.SqlStr(lt_PriceInfoCommon.CT_Code))
        ls_Request = Replace(ls_Request, "$VEN_Id$", mo_Tools.SqlStr(cbo_Vendor.SelectedItem.Key))
        ls_Request = Replace(ls_Request, "$CURR_Code$", mo_Tools.SqlStr(lt_PriceInfoCommon.CURR_Code))
        
        If lt_PriceInfo(lngRow).CatIdx = eDPCCategory.cgSubconstructionArticle Then
            ls_Request = Replace(ls_Request, "$UM_CodeQ$", mo_Tools.SqlStr(DPC_UOM_PU))
        Else
            ls_Request = Replace(ls_Request, "$UM_CodeQ$", mo_Tools.SqlStr(DPC_UOM_M2))
        End If
        
        If lt_PriceInfo(lngRow).CatIdx = eDPCCategory.cgSurcharge Then
            ls_Request = Replace(ls_Request, "$UM_CodeC$", mo_Tools.SqlStr(DPC_UOM_PCS))
            
        ElseIf lt_PriceInfo(lngRow).CatIdx = eDPCCategory.cgMetalPanelSKU Then
            ls_Request = Replace(ls_Request, "$UM_CodeC$", mo_Tools.SqlStr(lt_PriceInfo(lngRow).UM_CodeC))
            
        ElseIf lt_PriceInfo(lngRow).CatIdx = eDPCCategory.cgSubconstructionArticle Then
            ls_Request = Replace(ls_Request, "$UM_CodeC$", mo_Tools.SqlStr(lt_PriceInfo(lngRow).UM_CodeC))
        
        Else
            ls_Request = Replace(ls_Request, "$UM_CodeC$", mo_Tools.SqlStr(DPC_UOM_M2))
        End If
        ls_Request = Replace(ls_Request, "$PRC_VStart$", mo_Tools.SqlDate(lt_PriceInfoCommon.VStart))
        ls_Request = Replace(ls_Request, "$PRC_VExp$", mo_Tools.SqlDate(lt_PriceInfoCommon.VExp))
        ls_Request = Replace(ls_Request, "$QMin$", mo_Tools.SqlDbl(lt_PriceInfo(lngRow).QMin))
        ls_Request = Replace(ls_Request, "$QMax$", mo_Tools.SqlDbl(lt_PriceInfo(lngRow).QMax))
        ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
        
        If mo_Db.RowCount(ll_Cursor) = 1 Then
            If lt_PriceInfo(lngRow).Cost = -1 Then
                'delete prices
                If cbo_Destination.SelectedItem.Key = eImportDest.idPrice Then
                    ls_Request = SQL_PRICE_DEL
                Else
                    ls_Request = SQL_COST_DEL
                End If
                ls_Request = Replace(ls_Request, "$PRC_Id$", mo_Tools.SqlInt(mo_Db.GetFields(ll_Cursor, "PRC_Id")))
                ls_Request = Replace(ls_Request, "$iConcurrency$", mo_Tools.SqlInt(mo_Db.GetFields(ll_Cursor, "iConcurrency")))
                ls_Request = Replace(ls_Request, "$U_Code$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
        
                Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Request)
                lt_ExcelImported.DeletedCountPrices = lt_ExcelImported.DeletedCountPrices + 1
            Else
                'update prices
                If cbo_Destination.SelectedItem.Key = eImportDest.idPrice Then
                    ls_Request = SQL_PRICE_UPD
                Else
                    ls_Request = SQL_COST_UPD
                End If
                ls_Request = Replace(ls_Request, "$PRC_Id$", mo_Tools.SqlInt(mo_Db.GetFields(ll_Cursor, "PRC_Id")))
                ls_Request = Replace(ls_Request, "$iConcurrency$", mo_Tools.SqlInt(mo_Db.GetFields(ll_Cursor, "iConcurrency")))
                If lt_PriceInfo(lngRow).Cost <> -1 Then
                    lt_ExcelImported.UpdatedCountPrices = lt_ExcelImported.UpdatedCountPrices + 1
                End If
            End If
        ElseIf mo_Db.RowCount(ll_Cursor) = 0 Then
            If cbo_Destination.SelectedItem.Key = eImportDest.idPrice Then
                ls_Request = SQL_PRICE_INS
                ls_Request = Replace(ls_Request, "$PRC_Id$", mo_Tools.SqlInt(mo_Tools.GetNextID(mo_Db, "DPC_Price")))
            Else
                ls_Request = SQL_COST_INS
                ls_Request = Replace(ls_Request, "$PRC_Id$", mo_Tools.SqlInt(mo_Tools.GetNextID(mo_Db, "DPC_Cost")))
            End If
            If lt_PriceInfo(lngRow).Cost <> -1 Then
                lt_ExcelImported.InsertedCountPrices = lt_ExcelImported.InsertedCountPrices + 1
            End If
        Else
            Call LogGridMsg("Multiple prices for line:" & lngRow & " and PRD_Id = " & lt_PriceInfo(lngRow).PRD_Id)
            mo_Db.Close (ll_Cursor)
            GoTo NextImportPriceRow
        End If
        mo_Db.Close (ll_Cursor)
                                                                                                                                                                                                                                                               
        If lt_PriceInfo(lngRow).Cost <> -1 Then
        
            ls_Request = Replace(ls_Request, "$PCR_Id$", mo_Tools.SqlInt(lt_PriceInfo(lngRow).PCR_Id), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PRD_Id$", mo_Tools.SqlStr(lt_PriceInfo(lngRow).PRD_Id), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$CT_Code$", mo_Tools.SqlStr(lt_PriceInfoCommon.CT_Code), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$VEN_Id$", mo_Tools.SqlStr(cbo_Vendor.SelectedItem.Key))
            ls_Request = Replace(ls_Request, "$CURR_Code$", mo_Tools.SqlStr(lt_PriceInfoCommon.CURR_Code), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PRC_VStart$", mo_Tools.SqlDate(lt_PriceInfoCommon.VStart), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PRC_VExp$", mo_Tools.SqlDate(lt_PriceInfoCommon.VExp), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PRC_QMin$", mo_Tools.SqlDbl(lt_PriceInfo(lngRow).QMin), , , vbTextCompare)
            ls_Request = Replace(ls_Request, "$PRC_QMax$", mo_Tools.SqlDbl(lt_PriceInfo(lngRow).QMax), , , vbTextCompare)
            
            If lt_PriceInfo(lngRow).CatIdx = eDPCCategory.cgSubconstructionArticle Then
                ls_Request = Replace(ls_Request, "$UM_CodeQ$", mo_Tools.SqlStr(DPC_UOM_PU), , , vbTextCompare)
            Else
                ls_Request = Replace(ls_Request, "$UM_CodeQ$", mo_Tools.SqlStr(DPC_UOM_M2), , , vbTextCompare)
            End If
            ls_Request = Replace(ls_Request, "$PRC_Cost$", mo_Tools.SqlDbl(lt_PriceInfo(lngRow).Cost), , , vbTextCompare)
            
            If lt_PriceInfo(lngRow).CatIdx = eDPCCategory.cgSurcharge Then
                ls_Request = Replace(ls_Request, "$UM_CodeC$", mo_Tools.SqlStr(DPC_UOM_PCS), , , vbTextCompare)
            
            ElseIf lt_PriceInfo(lngRow).CatIdx = eDPCCategory.cgMetalPanelSKU Or _
                   lt_PriceInfo(lngRow).CatIdx = eDPCCategory.cgSubconstructionArticle Then
                   
                ls_Request = Replace(ls_Request, "$UM_CodeC$", mo_Tools.SqlStr(lt_PriceInfo(lngRow).UM_CodeC))
            
            Else
                ls_Request = Replace(ls_Request, "$UM_CodeC$", mo_Tools.SqlStr(DPC_UOM_M2), , , vbTextCompare)
            End If
            ls_Request = Replace(ls_Request, "$U_Code$", mo_Tools.SqlInt(ml_U_Code), , , vbTextCompare)
        
            Call mo_Tools.ExecuteSQLSafe(mo_Db, ls_Request)
        End If
                                                            
        GoTo NextImportPriceRow
        'error managment - if import failed, continue to import next row
ErrorImportPriceRow:
        Call LogGridMsg("ImportPrice PRD_Id=" & lt_PriceInfo(lngRow).PRD_Id & " error:" & Err.Description)
        Resume NextImportPriceRow
NextImportPriceRow:
    Next
        
    Call ProgressBarLabel(mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 10, "#Finished."))
    Call LogGridMsg("Inserted Prices = " & lt_ExcelImported.InsertedCountPrices & _
                    ", Updated Prices = " & lt_ExcelImported.UpdatedCountPrices & _
                    ", Deleted Prices = " & lt_ExcelImported.DeletedCountPrices & _
                    ", Inserted PriceCrits = " & lt_ExcelImported.InsertedCountPriceCrits)
                    
    ImportPrice = True
    
    Exit Function
ErrHandler:
    ImportPrice = False
    Call ErrorHandler("ImportPrice")
End Function

Private Function Check_Table(ByRef at_PriceCritInfoCommon As tPriceCrit, ByRef at_PriceCritInfo() As tPriceCrit, _
                        ByRef at_PriceInfo() As tPrice, ByRef as_CommonRequest As String, ByRef as_PriceCommonRequest As String, _
                        ByRef al_StartRow As Long, ByRef av_DataArray As Variant, ByVal as_tableName As String, ByVal al_CatId As Long, ByRef al_ExcelImported As tExcelImported, ByVal al_DetectionColumn As Long) As Boolean
On Error GoTo ErrHandler

    Dim ll_Err As String
    Dim ll_BMinMax_Start As Long
    Dim lv_Info(1) As String
    Dim ll_Idx As Long
    
    Check_Table = False
    
    lv_Info(0) = "%"
    lv_Info(1) = as_tableName
    Call ProgressBarLabel(mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 11, "#Checking % table ...", lv_Info))
    
    If al_StartRow <= 0 Then
        Call LogGridMsg(as_tableName & " data start row error")
        Exit Function
    End If
    
    If mt_ImportType = eImportType.itFixed Then
        ll_BMinMax_Start = 9
    Else
        ll_BMinMax_Start = 9
    End If
    
    For al_StartRow = al_StartRow To UBound(av_DataArray, 1)
    
        Call ProgressBarStep
                
        'total row counter
        al_ExcelImported.Count = al_ExcelImported.Count + 1
                
        'detect end of table (B-min, B-max is empty)
        If av_DataArray(al_StartRow, al_DetectionColumn) = "" Then
            Exit For
        End If
                    
        'import pricecrit
        If ImportPriceCrit_CheckExcelData(av_DataArray, at_PriceCritInfoCommon, at_PriceCritInfo, at_PriceInfo, as_CommonRequest, as_PriceCommonRequest, al_CatId, al_StartRow, ll_BMinMax_Start, txt_TableStart.Text - 3, txt_TableStart.Text - 2, ll_Err) = False Then
            'add error message into grid
            Call LogGridMsg(ll_Err)
            Exit Function
        End If
        
    Next
    
    Check_Table = True
    
    Exit Function
ErrHandler:
    Call ErrorHandler("GetLngRowForTable")
End Function

Private Sub LogGridMsg(ByVal as_Msg As String)
On Error GoTo ErrHandler
            
    ReDim lv_Data(grd_PriceImport.Cols - 1)
    lv_Data(0) = ""         ' this is new
            
    If grd_PriceImport.AddLine(lv_Data) Then
                              
        grd_PriceImport.SelectedLine(0, 0) = "0"
        grd_PriceImport.SelectedLine(0, 1) = as_Msg
    
    End If
    Exit Sub
ErrHandler:
    Call ErrorHandler("GetLngRowForTable")
End Sub

Private Function FindIndexForCategory(ByVal al_CatId As Long) As Long
On Error GoTo ErrHandler

    Dim ll_CatIndex As Long
    
    'find index for category
    FindIndexForCategory = -1
    For ll_CatIndex = 0 To UBound(mt_PriceCritForCategory)
        If mt_PriceCritForCategory(ll_CatIndex).CAT_Id = al_CatId Then
            FindIndexForCategory = ll_CatIndex
            Exit For
        End If
    Next
    Exit Function
ErrHandler:
    Call ErrorHandler("FindIndexForCategory")
End Function

Private Function ImportPriceCrit_CommonInfoCheck(ByRef at_PriceCritInfo As tPriceCrit, ByRef as_Request As String, ByRef al_CatIndex As Long, ByRef as_Err As String)
On Error GoTo ErrHandler

Const SQL_CATEGORY_SEL = "exec DPC_PriceCrit_chk3 '$PRD_Id$'"
                         
Const SQL_PRICECRIT_CHECK = "exec DPC_PriceCrit_chk '$PRD_Id$','$PRD_IdPar$',$CUA_JMin$,$CUA_JMax$," & _
                            "$CUA_KMin$,$CUA_KMax$,$CUA_DMin$,$CUA_DMax$,$MAT_Id$,$PCR_AMin$,$PCR_AMax$,$PCR_BMin$,$PCR_BMax$," & _
                            "$PCR_Thick$,$PCR_TMin$,$PCR_TMax$,'$PCR_IsPrf$',$PCR_GaCnt$,$PCR_CoSid$,$CAT_Id$,'$PRF_Class$','$SYS_Name$'"
    
Dim ll_Index, ll_Cursor As Long
Dim ll_CAT_Id, ll_CatIndex As Long
Dim ls_Request As String
Dim lb_CategoryFound As Boolean

    ImportPriceCrit_CommonInfoCheck = False
    
    If mt_ImportType = eImportType.itFixed Then
        ls_Request = SQL_PRICECRIT_CHECK
    Else

        If cbo_Product.SelectedItem Is Nothing Then
            as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 12, "#Product has to be selected")
            Exit Function
        End If
        
        at_PriceCritInfo.PRD_Id = cbo_Product.SelectedItem.Key
        
        ls_Request = SQL_CATEGORY_SEL
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PRD_Id$", at_PriceCritInfo.PRD_Id)
        ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
        
        If mo_Db.RowCount(ll_Cursor) = 1 Then
        
            ll_CAT_Id = mo_Db.GetFields(ll_Cursor, "CAT_Id")
            'll_CUT_Shape = mo_Db.GetFields(ll_Cursor, "CUT_Shape")
                    
        ElseIf mo_Db.RowCount(ll_Cursor) > 1 Then
            as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 34, "#Product in multiple categories for PRD_Id = ")
            as_Err = as_Err & at_PriceCritInfo.PRD_Id
            Call mo_Db.Close(ll_Cursor)
            Exit Function
        Else
            as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 35, "#Product missing for PRD_Id = ")
            as_Err = as_Err & at_PriceCritInfo.PRD_Id
            Call mo_Db.Close(ll_Cursor)
            Exit Function
        End If
        Call mo_Db.Close(ll_Cursor)
    
        If ll_CAT_Id = 0 Then
            as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 33, "#Category unknown for PRD_Id = ")
            as_Err = as_Err & at_PriceCritInfo.PRD_Id
            Exit Function
        End If
    
        'find index for category
        ll_CatIndex = FindIndexForCategory(ll_CAT_Id)
        
        If ll_CatIndex = -1 Then
            as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 32, "#Category not defined for PRD_Id = ")
            as_Err = as_Err & at_PriceCritInfo.PRD_Id
            Exit Function
        End If
        
        ls_Request = SQL_PRICECRIT_CHECK
            
        'ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PRD_Id$", cbo_ProductPar.SelectedItem.Key)
        at_PriceCritInfo.PRD_Id = cbo_Product.SelectedItem.Key
            
        If mt_PriceCritForCategory(ll_CatIndex).PRD_IdPar = True Then
            If cbo_ProductPar.SelectedItem Is Nothing Then
                as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 31, "#PRD_IdPar has to be selected")
                Exit Function
            End If
            ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PRD_IdPar$", cbo_ProductPar.SelectedItem.Key)
            at_PriceCritInfo.PRD_IdPar = cbo_ProductPar.SelectedItem.Key
        Else
            ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "'$PRD_CodePar$'", "Null")
            at_PriceCritInfo.PRD_IdPar = ""
        End If
    End If
        
    If mt_PriceCritForCategory(ll_CatIndex).CUA_Id = True Then
        'If ImportPrice_CheckCutArea(lv_DataArray, av_Headers, lngRow, ll_CUT_Shape, ls_Request, as_Err) = False Then
        '    Exit Function
        'End If
    Else
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$CUA_JMin$", "Null")
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$CUA_JMax$", "Null")
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$CUA_KMin$", "Null")
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$CUA_KMax$", "Null")
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$CUA_DMin$", "Null")
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$CUA_DMax$", "Null")
        at_PriceCritInfo.CUA_Id = -1
    End If
            
    as_Request = ls_Request
    al_CatIndex = ll_CatIndex
    
    ImportPriceCrit_CommonInfoCheck = True
    Exit Function
ErrHandler:
    as_Err = Err.Description
    ImportPriceCrit_CommonInfoCheck = False
End Function

Private Function ImportPriceCrit_CheckExcelData(ByRef lv_DataArray As Variant, ByRef at_PriceCritInfoCommon As tPriceCrit, _
    ByRef at_PriceCritInfo() As tPriceCrit, ByRef at_PriceInfo() As tPrice, ByVal as_CommonRequest As String, ByVal as_PriceCommonRequest As String, ByVal al_Category As Long, ByVal lngRow As Long, _
    ByVal al_EX_PCR_BMinMax_Start As Long, ByVal al_EX_PCR_BMin As Long, ByVal al_EX_PCR_BMax As Long, ByRef as_Err As String)
    
On Error GoTo ErrHandler

Dim ls_Request, ls_Request2, ls_BackuRequest As String
Dim ll_Index, ll_Cursor, ll_Cursor2 As Long
Dim ll_Value As Long
Dim ll_Idx2 As Long
Dim ll_CatIdx As Long
Dim ll_PCR_A_Min, ll_PCR_A_Max As Long
Dim ls_Existing As String
Dim la_Sizes() As String
Dim ll_Code_Column As Long
Dim ll_Value_Column As Long
Dim ll_Value_Row As Long
Dim ll_LastColumnToImport As Long

    If mt_ImportType = eImportType.itFixed Then
        If al_Category = eDPCCategory.cgMetalCustomPanelTemplate Then
            ll_Code_Column = al_EX_PCR_BMinMax_Start - 7
            ll_Value_Column = al_EX_PCR_BMinMax_Start - 2
        ElseIf al_Category = eDPCCategory.cgMetalPanelSKU Then
            ll_Code_Column = 2
            ll_Value_Row = 9
        ElseIf al_Category = eDPCCategory.cgCoating Then
            ll_Code_Column = al_EX_PCR_BMinMax_Start - 4
            ll_Value_Row = 21
        ElseIf al_Category = eDPCCategory.cgSurcharge Then
            ll_Code_Column = al_EX_PCR_BMinMax_Start - 7
            ll_Value_Row = 21 'position of surcharge code
            ll_Value_Column = 1 'column where is prf is indicated
        Else
            ll_Code_Column = al_EX_PCR_BMinMax_Start - 4
            ll_Value_Column = 1
        End If
    Else
        ll_Code_Column = al_EX_PCR_BMinMax_Start - 4    'netreba?
        ll_Value_Column = al_EX_PCR_BMinMax_Start - 1   'netreba?
    End If
    
    ll_CatIdx = FindIndexForCategory(al_Category)

    ImportPriceCrit_CheckExcelData = False
        
    ls_Request = as_CommonRequest
    
    If al_Category = eDPCCategory.cgMetalCustomPanelTemplate And mt_ImportType = itBended Then
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PRD_Id$", cbo_ProductPar.SelectedItem.Key)
    ElseIf al_Category = eDPCCategory.cgPerforation Then
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "'$PRD_Id$'", "Null")
    ElseIf al_Category = eDPCCategory.cgSurcharge Then
        'do nothing here
    ElseIf al_Category = eDPCCategory.cgCoating Or _
           al_Category = eDPCCategory.cgGasket Or _
           al_Category = eDPCCategory.cgInlay Or _
           al_Category = eDPCCategory.cgMetalPanelSKU Or _
           al_Category = eDPCCategory.cgPacking Or _
           al_Category = eDPCCategory.cgSubconstructionArticle Then
              
        ls_Request2 = "select PRD_Id from dpc_prdcommon where prd_code = '" & lv_DataArray(lngRow, ll_Code_Column) & "'"
        ll_Cursor2 = mo_Tools.OpenSQLSafe(mo_Db, ls_Request2)
        
        If Not mo_Db.EOF(ll_Cursor2) Then
            at_PriceCritInfoCommon.PRD_Id = mo_Db.GetFields(ll_Cursor2, "PRD_Id")
        Else
            Call mo_Db.Close(ll_Cursor2)
            as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 22, "#PRD_Id not found for PRD_Code:")
            as_Err = as_Err & lv_DataArray(lngRow, ll_Code_Column)
            Exit Function
        End If
        Call mo_Db.Close(ll_Cursor2)
           
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PRD_Id$", at_PriceCritInfoCommon.PRD_Id)
                                
    End If
    
    If mt_PriceCritForCategory(ll_CatIdx).MAT_Id = True Then
        If cbo_Material.SelectedItem Is Nothing Then
            as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 23, "#Material name has tobe selected.")
            Exit Function
        End If
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$MAT_Id$", cbo_Material.SelectedItem.Key)
        at_PriceCritInfoCommon.MAT_Id = cbo_Material.SelectedItem.Key
    Else
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$MAT_Id$", "Null")
        at_PriceCritInfoCommon.MAT_Id = -1
    End If

    If mt_PriceCritForCategory(ll_CatIdx).PCR_AMin = True Then
        If mt_ImportType = eImportType.itBended Then
            If lv_DataArray(lngRow, EX_PCR_AMin) = "NULL" Or lv_DataArray(lngRow, EX_PCR_AMin) = "" Then
                as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 24, "#PCR_AMin missing for line:")
                as_Err = as_Err & lngRow
                Exit Function
            End If
            ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_AMin$", mo_Tools.SqlDbl(lv_DataArray(lngRow, EX_PCR_AMin)))
            at_PriceCritInfoCommon.PCR_AMin = CDbl(lv_DataArray(lngRow, EX_PCR_AMin))
        End If
    Else
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_AMin$", "Null")
        at_PriceCritInfoCommon.PCR_AMin = -1
    End If
    
    If mt_PriceCritForCategory(ll_CatIdx).PCR_AMax = True Then
        If mt_ImportType = eImportType.itBended Then
            If lv_DataArray(lngRow, EX_PCR_AMax) = "NULL" Or lv_DataArray(lngRow, EX_PCR_AMax) = "" Then
                as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 25, "#PCR_AMax missing for line:")
                as_Err = as_Err & lngRow
                Exit Function
            End If
            ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_AMax$", mo_Tools.SqlDbl(lv_DataArray(lngRow, EX_PCR_AMax)))
            at_PriceCritInfoCommon.PCR_AMax = CDbl(lv_DataArray(lngRow, EX_PCR_AMax))
        End If
    Else
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_AMax$", "Null")
        at_PriceCritInfoCommon.PCR_AMax = -11
    End If
    
    If mt_PriceCritForCategory(ll_CatIdx).PCR_Thick = True Then
        If al_Category = eDPCCategory.cgMetalCustomPanelTemplate Then
            If txt_Thicknes.Text = "" Then
                as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 26, "#PCR_Thick has to be entered.")
                Exit Function
            End If
            ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_Thick$", mo_Tools.SqlDbl(txt_Thicknes.Text))
            at_PriceCritInfoCommon.PCR_Thick = CDbl(txt_Thicknes.Text)
        End If
    Else
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_Thick$", "Null")
        at_PriceCritInfoCommon.PCR_Thick = -1
    End If

    If mt_PriceCritForCategory(ll_CatIdx).PCR_CoSid = True Then
        
    Else
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_CoSid$", "Null")
        at_PriceCritInfoCommon.PCR_CoSid = "-1"
    End If
    
    If mt_PriceCritForCategory(ll_CatIdx).PCR_GaCnt = True Then
        If al_Category = eDPCCategory.cgGasket Then
            If Not IsNumeric(lv_DataArray(lngRow, ll_Value_Column)) Then
                as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 28, "#PCR_GaCnt is missing.")
                Exit Function
            Else
                ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_GaCnt$", lv_DataArray(lngRow, ll_Value_Column))
                at_PriceCritInfoCommon.PCR_GaCnt = lv_DataArray(lngRow, ll_Value_Column)
            End If
        End If
    Else
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_GaCnt$", "Null")
        at_PriceCritInfoCommon.PCR_GaCnt = -1
    End If
    
    If mt_PriceCritForCategory(ll_CatIdx).PCR_IsPrf = True Then
        If al_Category = eDPCCategory.cgMetalCustomPanelTemplate Then
            ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "'$PCR_IsPrf$'", mo_Tools.SqlBool(chk_IsPrf.Value))
            at_PriceCritInfoCommon.PCR_IsPrf = chk_IsPrf.Value
        ElseIf al_Category = eDPCCategory.cgSurcharge Then

        End If
    Else
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "'$PCR_IsPrf$'", "Null")
        at_PriceCritInfoCommon.PCR_IsPrf = False
    End If

    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$CAT_Id$", al_Category)

    If al_Category = eDPCCategory.cgPerforation Then
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PRF_Class$", lv_DataArray(lngRow, ll_Code_Column))
    Else
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "'$PRF_Class$'", "Null")
    End If

    If al_Category = eDPCCategory.cgSurcharge Then
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$SYS_Name$", lv_DataArray(lngRow, ll_Code_Column))
    Else
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "'$SYS_Name$'", "Null")
    End If

    ls_BackuRequest = ls_Request
        
    ll_LastColumnToImport = UBound(lv_DataArray, 2)
    
    If al_Category = eDPCCategory.cgMetalPanelSKU Then
        'for MetalPanelSKU category we need just one pass trough every row
        ll_LastColumnToImport = al_EX_PCR_BMinMax_Start
    End If
    
    For ll_Index = al_EX_PCR_BMinMax_Start To ll_LastColumnToImport
    
        ls_Request = ls_BackuRequest
        
        If Not IsEmpty(lv_DataArray(lngRow, ll_Index)) And IsNumeric(lv_DataArray(lngRow, ll_Index)) Or lv_DataArray(lngRow, ll_Index) = "X" Or lv_DataArray(lngRow, ll_Index) = "?" Then

             If al_Category = eDPCCategory.cgCoating Then
                
                If Not IsNumeric(lv_DataArray(ll_Value_Row, ll_Index)) Then
                    as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 27, "#PCR_CoSid is missing.")
                    Exit Function
                Else
                    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_CoSid$", lv_DataArray(ll_Value_Row, ll_Index))
                    at_PriceCritInfoCommon.PCR_CoSid = lv_DataArray(ll_Value_Row, ll_Index)
                End If
            End If

            If al_Category = eDPCCategory.cgSurcharge Then
            
                ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_IsPrf$", lv_DataArray(ll_Value_Row - 2, ll_Index))
                at_PriceCritInfoCommon.PCR_IsPrf = IIf(lv_DataArray(ll_Value_Row - 2, ll_Index) = "X", True, False)
            
                If IsEmpty(lv_DataArray(ll_Value_Row, ll_Index)) Then
                    as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 39, "#PRD_Code expected on position:")
                    as_Err = as_Err & (ll_Value_Row - 2) & "," & ll_Index
                    Exit Function
                End If
                
                ls_Request2 = "select PRD_Id from dpc_prdcommon where prd_code = '" & lv_DataArray(ll_Value_Row, ll_Index) & "'"
                ll_Cursor2 = mo_Tools.OpenSQLSafe(mo_Db, ls_Request2)
                
                If Not mo_Db.EOF(ll_Cursor2) Then
                    at_PriceCritInfoCommon.PRD_Id = mo_Db.GetFields(ll_Cursor2, "PRD_Id")
                Else
                    Call mo_Db.Close(ll_Cursor2)
                    as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 22, "#PRD_Id not found for PRD_Code:")
                    as_Err = as_Err & lv_DataArray(ll_Value_Row, ll_Index)
                    Exit Function
                End If
                Call mo_Db.Close(ll_Cursor2)
                   
                ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PRD_Id$", at_PriceCritInfoCommon.PRD_Id)
            End If
            
            If mt_PriceCritForCategory(ll_CatIdx).PCR_BMin = True Then
                If mt_ImportType <> eImportType.itFixed Or al_Category <> eDPCCategory.cgMetalCustomPanelTemplate Then
                    If lv_DataArray(al_EX_PCR_BMin, ll_Index) = "NULL" Or lv_DataArray(al_EX_PCR_BMin, ll_Index) = "" Then
                        as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 29, "#PCR_BMin missing for line: $line$ and column $column$")
                        as_Err = Replace(as_Err, "$line$", al_EX_PCR_BMin, , , vbTextCompare)
                        as_Err = Replace(as_Err, "$column$", ll_Index, , , vbTextCompare)
                        Exit Function
                    End If
                    
                    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_BMin$", mo_Tools.SqlDbl(lv_DataArray(al_EX_PCR_BMin, ll_Index)))
                    at_PriceCritInfoCommon.PCR_BMin = CDbl(lv_DataArray(al_EX_PCR_BMin, ll_Index))
                End If
            Else
                ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_BMin$", "Null")
                at_PriceCritInfoCommon.PCR_BMin = -1
            End If
            
            If mt_PriceCritForCategory(ll_CatIdx).PCR_BMax = True Then
                If lv_DataArray(al_EX_PCR_BMax, ll_Index) = "NULL" Or lv_DataArray(al_EX_PCR_BMax, ll_Index) = "" Then
                    If lv_DataArray(lngRow, ll_Index) = "X" Then
                        'sometimes there are additional X-es in excel without prices and column header (panel size)
                        'these are ignored
                        GoTo nextProduct
                    End If
                    as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 30, "#PCR_BMax missing for line: $line$ and column $column$")
                    as_Err = Replace(as_Err, "$line$", al_EX_PCR_BMax, , , vbTextCompare)
                    as_Err = Replace(as_Err, "$column$", ll_Index, , , vbTextCompare)
                    Exit Function
                End If
                If mt_ImportType = eImportType.itFixed And al_Category = eDPCCategory.cgMetalCustomPanelTemplate Then
                    
                    'here we save module sizes for later use
                    
                    at_PriceCritInfoCommon.PCR_AMin = CDbl(mo_Tools.SqlDbl(lv_DataArray(al_EX_PCR_BMax, ll_Index)))
                    at_PriceCritInfoCommon.PCR_BMin = CDbl(mo_Tools.SqlDbl(lv_DataArray(al_EX_PCR_BMin, ll_Index)))
                    
                    'If mt_PriceCritForCategory(ll_CatIdx).PCR_AMin = True Then
                    '    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_AMin$", mo_Tools.SqlDbl(lv_DataArray(al_EX_PCR_BMin, ll_Index)))
                    '    at_PriceCritInfoCommon.PCR_AMin = CDbl(mo_Tools.SqlDbl(lv_DataArray(al_EX_PCR_BMin, ll_Index)))
                    'Else
                    '    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_AMin$", "Null")
                    '    at_PriceCritInfoCommon.PCR_AMin = -1
                    'End If
                    'If mt_PriceCritForCategory(ll_CatIdx).PCR_AMax = True Then
                    '    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_AMax$", mo_Tools.SqlDbl(lv_DataArray(al_EX_PCR_BMin, ll_Index)))
                    '    at_PriceCritInfoCommon.PCR_AMax = CDbl(mo_Tools.SqlDbl(lv_DataArray(al_EX_PCR_BMin, ll_Index)))
                    'Else
                    '    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_AMax$", "Null")
                    '    at_PriceCritInfoCommon.PCR_AMax = -1
                    'End If
                    'ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_BMin$", mo_Tools.SqlDbl(lv_DataArray(al_EX_PCR_BMax, ll_Index)))
                    'ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_BMax$", mo_Tools.SqlDbl(lv_DataArray(al_EX_PCR_BMax, ll_Index)))
                    'at_PriceCritInfoCommon.PCR_BMin = CDbl(mo_Tools.SqlDbl(lv_DataArray(al_EX_PCR_BMax, ll_Index)))
                    'at_PriceCritInfoCommon.PCR_BMax = CDbl(mo_Tools.SqlDbl(lv_DataArray(al_EX_PCR_BMax, ll_Index)))
                Else
                    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_BMax$", mo_Tools.SqlDbl(lv_DataArray(al_EX_PCR_BMax, ll_Index)))
                    at_PriceCritInfoCommon.PCR_BMax = CDbl(lv_DataArray(al_EX_PCR_BMax, ll_Index))
                End If
            Else
                ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_BMax$", "Null")
                at_PriceCritInfoCommon.PCR_BMax = -1
            End If
        
            If mt_ImportType = eImportType.itFixed Then
            
                If al_Category = eDPCCategory.cgMetalCustomPanelTemplate Then
                    
                    ls_Request2 = "select prd.PRD_Id,prd.PRD_IdPar,rpa.rpl_panA,rpa.rpl_panB from dpc_rectpanel rpa " & _
                              "inner join dpc_prdcommon prd on prd.prd_id = rpa.rpl_id " & _
                              "inner join dpc_prddesc des on rpa.rpl_id = des.prd_id and des.language_code='E' " & _
                              "where prd.cat_id = " & al_Category & " and rpa.rpl_ModA=$PCR_AMin$" & _
                              " and rpa.rpl_ModB=$PCR_BMin$ and des.prd_name = '" & lv_DataArray(lngRow, 2) & "'"
                              
                    ls_Request2 = mo_Tools.ReplacePlaceHolder(ls_Request2, "$PCR_AMin$", mo_Tools.SqlDbl(at_PriceCritInfoCommon.PCR_AMin))
                    ls_Request2 = mo_Tools.ReplacePlaceHolder(ls_Request2, "$PCR_BMin$", mo_Tools.SqlDbl(at_PriceCritInfoCommon.PCR_BMin))
                              
                    ll_Cursor2 = mo_Tools.OpenSQLSafe(mo_Db, ls_Request2)
                    
                    If mo_Db.RowCount(ll_Cursor2) = 1 Then
                        at_PriceCritInfoCommon.PRD_Id = mo_Db.GetFields(ll_Cursor2, "PRD_Id")
                        at_PriceCritInfoCommon.PRD_IdPar = mo_Db.GetFields(ll_Cursor2, "PRD_Id")
                        at_PriceCritInfoCommon.PCR_AMin = mo_Db.GetFields(ll_Cursor2, "RPL_PanA")
                        at_PriceCritInfoCommon.PCR_AMax = mo_Db.GetFields(ll_Cursor2, "RPL_PanA")
                        at_PriceCritInfoCommon.PCR_BMin = mo_Db.GetFields(ll_Cursor2, "RPL_PanB")
                        at_PriceCritInfoCommon.PCR_BMax = mo_Db.GetFields(ll_Cursor2, "RPL_PanB")
                        
                        If UBound(mt_ProductInfo) = -1 Then
                            ReDim mt_ProductInfo(0)
                        Else
                            ReDim Preserve mt_ProductInfo(UBound(mt_ProductInfo) + 1)
                        End If
                        
                        mt_ProductInfo(UBound(mt_ProductInfo)).PRD_Id = at_PriceCritInfoCommon.PRD_Id
                        mt_ProductInfo(UBound(mt_ProductInfo)).AMin = at_PriceCritInfoCommon.PCR_AMin
                        mt_ProductInfo(UBound(mt_ProductInfo)).AMax = at_PriceCritInfoCommon.PCR_AMax
                        mt_ProductInfo(UBound(mt_ProductInfo)).BMin = at_PriceCritInfoCommon.PCR_BMin
                        mt_ProductInfo(UBound(mt_ProductInfo)).BMax = at_PriceCritInfoCommon.PCR_BMax
                        
                    ElseIf mo_Db.RowCount(ll_Cursor2) > 1 Then
                        'multiple products found!
                        Call mo_Db.Close(ll_Cursor2)
                        Call mo_Db.Close(ll_Cursor)
                        as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 20, "#PRD_Id duplicated for panel $Name$ for size:")
                        as_Err = Replace(as_Err, "$Name$", lv_DataArray(lngRow, 2), , , vbTextCompare)
                        as_Err = as_Err & at_PriceCritInfoCommon.PCR_BMin & " x " & at_PriceCritInfoCommon.PCR_AMin
                        Exit Function
                    ElseIf mo_Db.RowCount(ll_Cursor2) = 0 And lv_DataArray(lngRow, ll_Index) <> "X" Then
                        'the product not found but the price is defined in excel!
                        Call mo_Db.Close(ll_Cursor2)
                        Call mo_Db.Close(ll_Cursor)
                        as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 21, "#Panel PRD_Id not found for panel $Name$ for size:")
                        as_Err = Replace(as_Err, "$Name$", lv_DataArray(lngRow, 2), , , vbTextCompare)
                        as_Err = as_Err & at_PriceCritInfoCommon.PCR_BMin & " x " & at_PriceCritInfoCommon.PCR_AMin
                        Exit Function
                    Else
                        'the prodcut not found but there is no price defined for this size, so it is ok
                        Call mo_Db.Close(ll_Cursor2)
                        GoTo nextProduct
                    End If
                    Call mo_Db.Close(ll_Cursor2)
                    
                    'now we have prd_id so we can check if there are overlaped prices defined
                    ls_Request2 = mo_Tools.ReplacePlaceHolder(as_PriceCommonRequest, "$PRD_Id$", at_PriceCritInfoCommon.PRD_Id)
                    ll_Cursor2 = mo_Tools.OpenSQLSafe(mo_Db, ls_Request2)
                    If Not mo_Db.EOF(ll_Cursor2) Then
                        as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 19, "#Overlapped date for this product, prices already imported for period")
                        as_Err = as_Err & " " & mo_Db.GetFields(ll_Cursor2, "PRC_VStart") & " - " & mo_Db.GetFields(ll_Cursor2, "PRC_VExp")
                        Call mo_Db.Close(ll_Cursor2)
                        Call mo_Db.Close(ll_Cursor)
                        Exit Function
                    End If
                    Call mo_Db.Close(ll_Cursor2)
                
                    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PRD_Id$", at_PriceCritInfoCommon.PRD_Id)
                    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PRD_IdPar$", at_PriceCritInfoCommon.PRD_IdPar)
                    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_AMin$", mo_Tools.SqlDbl(at_PriceCritInfoCommon.PCR_AMin))
                    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_AMax$", mo_Tools.SqlDbl(at_PriceCritInfoCommon.PCR_AMax))
                    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_BMin$", mo_Tools.SqlDbl(at_PriceCritInfoCommon.PCR_BMin))
                    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_BMax$", mo_Tools.SqlDbl(at_PriceCritInfoCommon.PCR_BMax))
                End If
                    
                If al_Category = eDPCCategory.cgMetalPanelSKU Then
                    ls_Request2 = mo_Tools.ReplacePlaceHolder(as_PriceCommonRequest, "$PRD_Id$", at_PriceCritInfoCommon.PRD_Id)
                    ll_Cursor2 = mo_Tools.OpenSQLSafe(mo_Db, ls_Request2)
                    If Not mo_Db.EOF(ll_Cursor2) Then
                        as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 19, "#Overlapped date for this product, prices already imported for period")
                        as_Err = as_Err & " " & mo_Db.GetFields(ll_Cursor2, "PRC_VStart") & " - " & mo_Db.GetFields(ll_Cursor2, "PRC_VExp")
                        Call mo_Db.Close(ll_Cursor2)
                        Call mo_Db.Close(ll_Cursor)
                        Exit Function
                    End If
                    Call mo_Db.Close(ll_Cursor2)
                
                    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PRD_Id$", at_PriceCritInfoCommon.PRD_Id)
                End If

            End If

            If mt_PriceCritForCategory(ll_CatIdx).PCR_TMin = True Then
        '    If lv_DataArray(lngRow, av_Headers(EX_PCR_TMin)) = "NULL" Or lv_DataArray(lngRow, av_Headers(EX_PCR_TMin)) = "" Then
        '        as_Err = "PCR_TMin missing for line:" & lngRow
        '        Exit Function
        '    End If
        '    ls_Request = ReplacePlaceHolder(ls_Request, "$PCR_TMin$", lv_DataArray(lngRow, av_Headers(EX_PCR_TMin)))
            Else
                ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_TMin$", "Null")
                at_PriceCritInfoCommon.PCR_TMin = -1
            End If
        
            If mt_PriceCritForCategory(ll_CatIdx).PCR_TMax = True Then
        '    If lv_DataArray(lngRow, av_Headers(EX_PCR_TMax)) = "" Or lv_DataArray(lngRow, av_Headers(EX_PCR_TMax)) = "" Then
        '        as_Err = "PCR_TMax missing for line:" & lngRow
        '        Exit Function
        '    End If
        '    ls_Request = ReplacePlaceHolder(ls_Request, "$PCR_TMax$", lv_DataArray(lngRow, av_Headers(EX_PCR_TMax)))
            Else
                ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PCR_TMax$", "Null")
                at_PriceCritInfoCommon.PCR_TMax = -1
            End If
                                                    
            If mt_ImportType = eImportType.itFixed Then
                If al_Category <> eDPCCategory.cgMetalCustomPanelTemplate Then
                    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "'$PRD_IdPar$'", "Null")
                    at_PriceCritInfoCommon.PRD_IdPar = -1
                End If
            End If
            
            ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
            
            If mo_Db.RowCount(ll_Cursor) = 0 Then
                'there is new price crit which needs to be inserted into db
                If al_Category = eDPCCategory.cgMetalCustomPanelTemplate Then
                    Call AddPriceCritInfo(al_Category, at_PriceCritInfoCommon, at_PriceCritInfo, lv_DataArray(lngRow, ll_Index), txt_QtyMin.Text, txt_QtyMax.Text)
                
                ElseIf al_Category = eDPCCategory.cgMetalPanelSKU Then
                    Call AddPriceCritInfo(al_Category, at_PriceCritInfoCommon, at_PriceCritInfo, lv_DataArray(lngRow, ll_Index), txt_QtyMin.Text, txt_QtyMax.Text, DPC_UOM_M2)
                    Call AddPriceCritInfo(al_Category, at_PriceCritInfoCommon, at_PriceCritInfo, lv_DataArray(lngRow, ll_Index + 2), txt_QtyMin.Text, txt_QtyMax.Text, DPC_UOM_PCS)
                
                ElseIf al_Category = eDPCCategory.cgPerforation Then
                    ls_Request2 = "select pc.PRD_Id from dpc_prdcommon pc inner join dpc_perforation pr on pc.prd_id = pr.prf_id " & _
                                "and pc.drop_flag <> 'X' and pr.prf_class='" & lv_DataArray(lngRow, ll_Code_Column) & "'"
                                
                    ll_Cursor2 = mo_Tools.OpenSQLSafe(mo_Db, ls_Request2)
                    While Not mo_Db.EOF(ll_Cursor2)
                        at_PriceCritInfoCommon.PRD_Id = mo_Db.GetFields(ll_Cursor2, "PRD_Id")
                        Call AddPriceCritInfo(al_Category, at_PriceCritInfoCommon, at_PriceCritInfo, lv_DataArray(lngRow, ll_Index), lv_DataArray(lngRow, 6), lv_DataArray(lngRow, 7))
                        Call mo_Db.Next(ll_Cursor2)
                    Wend
                    Call mo_Db.Close(ll_Cursor2)
                
                ElseIf al_Category = eDPCCategory.cgSurcharge Then
                    ls_Request2 = "select des.sys_name, rpa.rpl_Id from dpc_rectpanel rpa " & _
                                  "inner join dpc_systemdesc des on rpa.sys_id = des.sys_id and des.language_code='E' " & _
                                  "inner join dpc_prdcommon prd on prd.prd_id = rpa.rpl_id and prd.cat_id=" & eDPCCategory.cgMetalCustomPanelTemplate & " " & _
                                  "where rpa.drop_flag <> 'X' and des.sys_name = '" & lv_DataArray(lngRow, ll_Code_Column) & "'"
                                
                    ll_Cursor2 = mo_Tools.OpenSQLSafe(mo_Db, ls_Request2)
                    If mo_Db.RowCount(ll_Cursor2) = 0 Then
                        'no products for this system
                        Call mo_Db.Close(ll_Cursor2)
                        Call mo_Db.Close(ll_Cursor)
                        as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 42, "#There are no poducts defined for $System$")
                        as_Err = Replace(as_Err, "$System$", lv_DataArray(lngRow, ll_Code_Column), , , vbTextCompare)
                        Exit Function
                    End If
                    While Not mo_Db.EOF(ll_Cursor2)
                        at_PriceCritInfoCommon.PRD_IdPar = mo_Db.GetFields(ll_Cursor2, "rpl_Id")
                        Call AddPriceCritInfo(al_Category, at_PriceCritInfoCommon, at_PriceCritInfo, lv_DataArray(lngRow, ll_Index), lv_DataArray(22, ll_Index), lv_DataArray(23, ll_Index))
                        Call mo_Db.Next(ll_Cursor2)
                    Wend
                    Call mo_Db.Close(ll_Cursor2)
                ElseIf al_Category = eDPCCategory.cgCoating Or _
                       al_Category = eDPCCategory.cgGasket Or _
                       al_Category = eDPCCategory.cgInlay Or _
                       al_Category = eDPCCategory.cgPacking Or _
                       al_Category = eDPCCategory.cgSubconstructionArticle Then
                       
                    Call AddPriceCritInfo(al_Category, at_PriceCritInfoCommon, at_PriceCritInfo, lv_DataArray(lngRow, ll_Index), lv_DataArray(lngRow, 6), lv_DataArray(lngRow, 7))
                ElseIf al_Category = eDPCCategory.cgSubconstructionArticle Then
                    Dim ls_UM_Code As String
                    ls_UM_Code = lv_DataArray(lngRow, 8)
                    Call AddPriceCritInfo(al_Category, at_PriceCritInfoCommon, at_PriceCritInfo, lv_DataArray(lngRow, ll_Index), lv_DataArray(lngRow, 6), lv_DataArray(lngRow, 7), ls_UM_Code)
                End If
                        
            Else
                ls_Existing = ""
                While Not mo_Db.EOF(ll_Cursor)
                                    
                    If UBound(at_PriceInfo) = -1 Then
                        ReDim at_PriceInfo(0)
                    Else
                        ReDim Preserve at_PriceInfo(UBound(at_PriceInfo) + 1)
                    End If
            
                    at_PriceInfo(UBound(at_PriceInfo)).PCR_Id = mo_Db.GetFields(ll_Cursor, "PCR_Id")
                    
                    If lv_DataArray(lngRow, ll_Index) <> "X" And lv_DataArray(lngRow, ll_Index) <> "?" Then
                        at_PriceInfo(UBound(at_PriceInfo)).Cost = CDbl(lv_DataArray(lngRow, ll_Index))
                    Else
                        at_PriceInfo(UBound(at_PriceInfo)).Cost = -1
                    End If
                    
                    at_PriceInfo(UBound(at_PriceInfo)).PRD_Id = mo_Db.GetFields(ll_Cursor, "PRD_Id")
                    at_PriceInfo(UBound(at_PriceInfo)).CatIdx = al_Category
                    
                    If al_Category = eDPCCategory.cgPerforation Or _
                       al_Category = eDPCCategory.cgCoating Or _
                       al_Category = eDPCCategory.cgGasket Or _
                       al_Category = eDPCCategory.cgInlay Or _
                       al_Category = eDPCCategory.cgPacking Or _
                       al_Category = eDPCCategory.cgSubconstructionArticle Then
                       
                        at_PriceInfo(UBound(at_PriceInfo)).QMin = lv_DataArray(lngRow, 6)
                        at_PriceInfo(UBound(at_PriceInfo)).QMax = lv_DataArray(lngRow, 7)
                    ElseIf al_Category = eDPCCategory.cgSurcharge Then
                        at_PriceInfo(UBound(at_PriceInfo)).QMin = lv_DataArray(22, ll_Index)
                        at_PriceInfo(UBound(at_PriceInfo)).QMax = lv_DataArray(23, ll_Index)
                    Else
                        at_PriceInfo(UBound(at_PriceInfo)).QMin = txt_QtyMin.Text
                        at_PriceInfo(UBound(at_PriceInfo)).QMax = txt_QtyMax.Text
                    End If
                    
                    If al_Category = eDPCCategory.cgSubconstructionArticle Then
                        at_PriceInfo(UBound(at_PriceInfo)).UM_CodeC = Trim(lv_DataArray(lngRow, 8))
                    End If
                    
                    If al_Category = eDPCCategory.cgMetalPanelSKU Then
                        'for this category, there are 2 prices for product in one row together with different values
                        'so we create prices in one step, and in main cycle we do not continue to importing other columns
                        
                        at_PriceInfo(UBound(at_PriceInfo)).UM_CodeC = DPC_UOM_M2
                        
                        ReDim Preserve at_PriceInfo(UBound(at_PriceInfo) + 1)
                    
                        at_PriceInfo(UBound(at_PriceInfo)).PCR_Id = mo_Db.GetFields(ll_Cursor, "PCR_Id")
                        
                        If lv_DataArray(lngRow, ll_Index) <> "X" And lv_DataArray(lngRow, ll_Index) <> "?" Then
                            at_PriceInfo(UBound(at_PriceInfo)).Cost = CDbl(lv_DataArray(lngRow, ll_Index + 2))
                        Else
                            at_PriceInfo(UBound(at_PriceInfo)).Cost = -1
                        End If
                        
                        at_PriceInfo(UBound(at_PriceInfo)).PRD_Id = mo_Db.GetFields(ll_Cursor, "PRD_Id")
                        at_PriceInfo(UBound(at_PriceInfo)).CatIdx = al_Category
                        at_PriceInfo(UBound(at_PriceInfo)).QMin = txt_QtyMin.Text
                        at_PriceInfo(UBound(at_PriceInfo)).QMax = txt_QtyMax.Text
                        at_PriceInfo(UBound(at_PriceInfo)).UM_CodeC = DPC_UOM_PCS
                    End If

                    If ls_Existing = "" Then
                        If al_Category = eDPCCategory.cgSurcharge Then
                            ls_Existing = "'" & mo_Db.GetFields(ll_Cursor, "PRD_IdPar") & "'"
                        Else
                            ls_Existing = "'" & mo_Db.GetFields(ll_Cursor, "PRD_Id") & "'"
                        End If
                    Else
                        If al_Category = eDPCCategory.cgSurcharge Then
                            ls_Existing = ls_Existing & ",'" & mo_Db.GetFields(ll_Cursor, "PRD_IdPar") & "'"
                        Else
                            ls_Existing = ls_Existing & ",'" & mo_Db.GetFields(ll_Cursor, "PRD_Id") & "'"
                        End If
                    End If
                                            
                    Call mo_Db.Next(ll_Cursor)
                Wend
                
                If al_Category = eDPCCategory.cgPerforation Then
                    ls_Request2 = "select PRF_Id from dpc_prdcommon pc inner join dpc_perforation pr on pc.prd_id = pr.prf_id " & _
                                "where pc.drop_flag <> 'X' and pr.prf_class='" & lv_DataArray(lngRow, ll_Code_Column) & "' " & _
                                "and pr.prf_id not in (" & ls_Existing & ")"
                                
                    ll_Cursor2 = mo_Tools.OpenSQLSafe(mo_Db, ls_Request2)
                    While Not mo_Db.EOF(ll_Cursor2)
                        at_PriceCritInfoCommon.PRD_Id = mo_Db.GetFields(ll_Cursor2, "PRF_Id")
                        Call AddPriceCritInfo(al_Category, at_PriceCritInfoCommon, at_PriceCritInfo, lv_DataArray(lngRow, ll_Index), lv_DataArray(lngRow, 6), lv_DataArray(lngRow, 7))
                        Call mo_Db.Next(ll_Cursor2)
                    Wend
                    Call mo_Db.Close(ll_Cursor2)
                ElseIf al_Category = eDPCCategory.cgSurcharge Then
                    ls_Request2 = "select PRD_Id from dpc_prdcommon pc " & _
                                "inner join dpc_rectpanel rpl on pc.prd_id = rpl.rpl_id " & _
                                "inner join dpc_systemdesc sys on sys.sys_id = rpl.sys_id and pc.cat_id=" & eDPCCategory.cgMetalCustomPanelTemplate & " " & _
                                "where pc.drop_flag <> 'X' and sys.sys_name ='" & lv_DataArray(lngRow, ll_Code_Column) & "' " & _
                                "and pc.prd_id not in (" & ls_Existing & ")"
                                
                    ll_Cursor2 = mo_Tools.OpenSQLSafe(mo_Db, ls_Request2)
                    While Not mo_Db.EOF(ll_Cursor2)
                        at_PriceCritInfoCommon.PRD_IdPar = mo_Db.GetFields(ll_Cursor2, "PRD_Id")
                        Call AddPriceCritInfo(al_Category, at_PriceCritInfoCommon, at_PriceCritInfo, CDbl(lv_DataArray(lngRow, ll_Index)), lv_DataArray(22, ll_Index), lv_DataArray(23, ll_Index))
                        Call mo_Db.Next(ll_Cursor2)
                    Wend
                    Call mo_Db.Close(ll_Cursor2)

                End If
            End If
            
            Call mo_Db.Close(ll_Cursor)
            
        End If
        
nextProduct:
    Next
    
    ImportPriceCrit_CheckExcelData = True
    Exit Function
ErrHandler:
    as_Err = Err.Description
    ImportPriceCrit_CheckExcelData = False
End Function

Private Sub AddPriceCritInfo(ByVal al_Category As Long, ByRef at_PriceCritInfoCommon As tPriceCrit, ByRef at_PriceCritInfo() As tPriceCrit, _
                            ByVal as_Cost As String, ByVal ad_QMin As Double, ByVal ad_QMax As Double, Optional as_UM_CodeC As String = DPC_UOM_M2)
On Error GoTo ErrHandler

    Dim ll_Idx2 As Long
    
    If UBound(at_PriceCritInfo) = -1 Then
        ReDim at_PriceCritInfo(0)
    Else
        ReDim Preserve at_PriceCritInfo(UBound(at_PriceCritInfo) + 1)
    End If
    
    ll_Idx2 = UBound(at_PriceCritInfo)
        
    at_PriceCritInfo(ll_Idx2).CatIdx = al_Category
    at_PriceCritInfo(ll_Idx2).PRD_Id = at_PriceCritInfoCommon.PRD_Id
    at_PriceCritInfo(ll_Idx2).PRD_IdPar = at_PriceCritInfoCommon.PRD_IdPar
    at_PriceCritInfo(ll_Idx2).CUA_Id = at_PriceCritInfoCommon.CUA_Id
    at_PriceCritInfo(ll_Idx2).PCR_AMin = at_PriceCritInfoCommon.PCR_AMin
    at_PriceCritInfo(ll_Idx2).PCR_AMax = at_PriceCritInfoCommon.PCR_AMax
    at_PriceCritInfo(ll_Idx2).PCR_BMin = at_PriceCritInfoCommon.PCR_BMin
    at_PriceCritInfo(ll_Idx2).PCR_BMax = at_PriceCritInfoCommon.PCR_BMax
    at_PriceCritInfo(ll_Idx2).MAT_Id = at_PriceCritInfoCommon.MAT_Id
    at_PriceCritInfo(ll_Idx2).PCR_Thick = at_PriceCritInfoCommon.PCR_Thick
    at_PriceCritInfo(ll_Idx2).PCR_TMin = at_PriceCritInfoCommon.PCR_TMin
    at_PriceCritInfo(ll_Idx2).PCR_TMax = at_PriceCritInfoCommon.PCR_TMax
    at_PriceCritInfo(ll_Idx2).PCR_IsPrf = at_PriceCritInfoCommon.PCR_IsPrf
    at_PriceCritInfo(ll_Idx2).PCR_CoSid = at_PriceCritInfoCommon.PCR_CoSid
    at_PriceCritInfo(ll_Idx2).PCR_GaCnt = at_PriceCritInfoCommon.PCR_GaCnt
    If as_Cost = "X" Or as_Cost = "?" Then
        at_PriceCritInfo(ll_Idx2).Cost = -1
    Else
        at_PriceCritInfo(ll_Idx2).Cost = CDbl(as_Cost)
    End If
    at_PriceCritInfo(ll_Idx2).QMin = ad_QMin
    at_PriceCritInfo(ll_Idx2).QMax = ad_QMax
    at_PriceCritInfo(ll_Idx2).AlreadyInserted = CheckIfAlreadyExists(at_PriceCritInfo, ll_Idx2)
    at_PriceCritInfo(ll_Idx2).UM_CodeC = as_UM_CodeC

    Exit Sub
ErrHandler:
    Call ErrorHandler("AddPriceCritInfo")
End Sub

Private Function CheckIfAlreadyExists(ByRef at_PriceCritInfo() As tPriceCrit, ByVal al_Idx As Long) As Boolean
On Error GoTo ErrHandler

Dim ll_Index As Long

    CheckIfAlreadyExists = False
    
    For ll_Index = 0 To UBound(at_PriceCritInfo)
    
        If ll_Index <> al_Idx Then
            If at_PriceCritInfo(ll_Index).CatIdx = at_PriceCritInfo(al_Idx).CatIdx And _
                at_PriceCritInfo(ll_Index).PRD_Id = at_PriceCritInfo(al_Idx).PRD_Id And _
                at_PriceCritInfo(ll_Index).PRD_IdPar = at_PriceCritInfo(al_Idx).PRD_IdPar And _
                at_PriceCritInfo(ll_Index).CUA_Id = at_PriceCritInfo(al_Idx).CUA_Id And _
                at_PriceCritInfo(ll_Index).PCR_AMin = at_PriceCritInfo(al_Idx).PCR_AMin And _
                at_PriceCritInfo(ll_Index).PCR_AMax = at_PriceCritInfo(al_Idx).PCR_AMax And _
                at_PriceCritInfo(ll_Index).PCR_BMin = at_PriceCritInfo(al_Idx).PCR_BMin And _
                at_PriceCritInfo(ll_Index).PCR_BMax = at_PriceCritInfo(al_Idx).PCR_BMax And _
                at_PriceCritInfo(ll_Index).MAT_Id = at_PriceCritInfo(al_Idx).MAT_Id And _
                at_PriceCritInfo(ll_Index).PCR_Thick = at_PriceCritInfo(al_Idx).PCR_Thick And _
                at_PriceCritInfo(ll_Index).PCR_TMin = at_PriceCritInfo(al_Idx).PCR_TMin And _
                at_PriceCritInfo(ll_Index).PCR_TMax = at_PriceCritInfo(al_Idx).PCR_TMax And _
                at_PriceCritInfo(ll_Index).PCR_IsPrf = at_PriceCritInfo(al_Idx).PCR_IsPrf And _
                at_PriceCritInfo(ll_Index).PCR_CoSid = at_PriceCritInfo(al_Idx).PCR_CoSid And _
                at_PriceCritInfo(ll_Index).PCR_GaCnt = at_PriceCritInfo(al_Idx).PCR_GaCnt Then
                
                CheckIfAlreadyExists = True
                Exit Function
            End If
        End If
    Next
        

    Exit Function
ErrHandler:
    Call ErrorHandler("CheckIfAlreadyExists")
End Function

Private Function FindPCRForInsertedPriceCrit(ByRef at_PriceCritInfo() As tPriceCrit, ByVal al_Idx As Long) As Long
On Error GoTo ErrHandler

Dim ll_Index As Long

    FindPCRForInsertedPriceCrit = -1
    
    For ll_Index = 0 To UBound(at_PriceCritInfo)
    
        If ll_Index <> al_Idx Then
            If at_PriceCritInfo(ll_Index).CatIdx = at_PriceCritInfo(al_Idx).CatIdx And _
                at_PriceCritInfo(ll_Index).PRD_Id = at_PriceCritInfo(al_Idx).PRD_Id And _
                at_PriceCritInfo(ll_Index).PRD_IdPar = at_PriceCritInfo(al_Idx).PRD_IdPar And _
                at_PriceCritInfo(ll_Index).CUA_Id = at_PriceCritInfo(al_Idx).CUA_Id And _
                at_PriceCritInfo(ll_Index).PCR_AMin = at_PriceCritInfo(al_Idx).PCR_AMin And _
                at_PriceCritInfo(ll_Index).PCR_AMax = at_PriceCritInfo(al_Idx).PCR_AMax And _
                at_PriceCritInfo(ll_Index).PCR_BMin = at_PriceCritInfo(al_Idx).PCR_BMin And _
                at_PriceCritInfo(ll_Index).PCR_BMax = at_PriceCritInfo(al_Idx).PCR_BMax And _
                at_PriceCritInfo(ll_Index).MAT_Id = at_PriceCritInfo(al_Idx).MAT_Id And _
                at_PriceCritInfo(ll_Index).PCR_Thick = at_PriceCritInfo(al_Idx).PCR_Thick And _
                at_PriceCritInfo(ll_Index).PCR_TMin = at_PriceCritInfo(al_Idx).PCR_TMin And _
                at_PriceCritInfo(ll_Index).PCR_TMax = at_PriceCritInfo(al_Idx).PCR_TMax And _
                at_PriceCritInfo(ll_Index).PCR_IsPrf = at_PriceCritInfo(al_Idx).PCR_IsPrf And _
                at_PriceCritInfo(ll_Index).PCR_CoSid = at_PriceCritInfo(al_Idx).PCR_CoSid And _
                at_PriceCritInfo(ll_Index).PCR_GaCnt = at_PriceCritInfo(al_Idx).PCR_GaCnt Then
                
                FindPCRForInsertedPriceCrit = at_PriceCritInfo(ll_Index).PCR_Id
                Exit Function
            End If
        End If
    Next
        
    Exit Function
ErrHandler:
    Call ErrorHandler("FindPCRForInsertedPriceCrit")
End Function

Private Function ImportPrice_CommonInfoCheck(ByRef at_PriceInfo As tPrice, ByRef as_Request As String, ByRef as_Err As String)
On Error GoTo ErrHandler
                         
Const SQL_PRICE_CHECK = "exec DPC_Price_chk2 '$PRD_Id$','$CT_Code$','$CURR_Code$',$UM_CodeQ$,$PRC_VStart$,$PRC_VExp$,$QMin$,$QMax$,$UM_CodeC$"
Const SQL_COST_CHECK = "exec DPC_Cost_chk2 '$PRD_Id$','$CT_Code$','$CURR_Code$',$UM_CodeQ$,$PRC_VStart$,$PRC_VExp$,$QMin$,$QMax$,$UM_CodeC$"
    
Dim ll_Index, ll_Cursor As Long
Dim ll_CAT_Id, ll_CatIndex As Long
Dim ls_Request As String
Dim lb_CategoryFound As Boolean

    ImportPrice_CommonInfoCheck = False
    
    If cbo_Destination.SelectedItem.Key = eImportDest.idPrice Then
    ls_Request = SQL_PRICE_CHECK
    Else
        ls_Request = SQL_COST_CHECK
    End If
        
    If mt_ImportType <> eImportType.itFixed Then

        If cbo_Product.SelectedItem Is Nothing Then
            as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 12, "#Product has to be selected.")
            Exit Function
        End If
    
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PRD_Id$", cbo_ProductPar.SelectedItem.Key)
        at_PriceInfo.PRD_Id = cbo_Product.SelectedItem.Key
    End If
        
    If cbo_Countries.SelectedItem Is Nothing Then
        as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 13, "#Country has to be selected.")
        Exit Function
    End If
    
    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$CT_Code$", cbo_Countries.SelectedItem.Key)
    at_PriceInfo.CT_Code = cbo_Countries.SelectedItem.Key
        
    If cbo_Currency.SelectedItem Is Nothing Then
        as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 14, "#Currency has to be selected.")
        Exit Function
    End If
    
    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$CURR_Code$", cbo_Currency.SelectedItem.Key)
    at_PriceInfo.CURR_Code = cbo_Currency.SelectedItem.Key
                            
    If txt_QtyMin.Text = "" Or Not IsNumeric(txt_QtyMin.Text) Then
        as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 15, "#Minimum Quantity has to be entered.")
        Exit Function
    Else
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$QMin$", mo_Tools.SqlInt(txt_QtyMin))
    End If
    
    at_PriceInfo.QMin = txt_QtyMin.Text
            
    If txt_QtyMax.Text = "" Or Not IsNumeric(txt_QtyMax.Text) Then
        as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 16, "#Maximum Quantity has to be entered.")
        Exit Function
    Else
        ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$QMax$", mo_Tools.SqlInt(txt_QtyMax))
    End If
    
    at_PriceInfo.QMax = txt_QtyMax.Text
            
    If CDbl(txt_QtyMax.Text) <= CDbl(txt_QtyMin.Text) Then
        as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 17, "#Maximum Quantity is less than Minimum Quantity.")
        Exit Function
    End If
            
    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PRC_VStart$", mo_Tools.SqlDate(cal_StartV.date_courte))
    at_PriceInfo.VStart = cal_StartV.date_courte
            
    ls_Request = mo_Tools.ReplacePlaceHolder(ls_Request, "$PRC_VExp$", mo_Tools.SqlDate(cal_EndV.date_courte))
    at_PriceInfo.VExp = cal_EndV.date_courte
            
    If cal_EndV.date_dt <= cal_StartV.date_dt Then
        as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 18, "#Exp Date is before Start Date.")
        Exit Function
    End If
            
    ls_Request = Replace(ls_Request, "$UM_CodeQ$", mo_Tools.SqlStr(DPC_UOM_M2), , , vbTextCompare)
    ls_Request = Replace(ls_Request, "$UM_CodeC$", mo_Tools.SqlStr(DPC_UOM_M2), , , vbTextCompare)
            
    If mt_ImportType <> eImportType.itFixed Then
        ll_Cursor = mo_Tools.OpenSQLSafe(mo_Db, ls_Request)
        If Not mo_Db.EOF(ll_Cursor) Then
            as_Err = mo_Tools.MsgText(mo_Db, ms_Language_Code, C_MSG_ID_BASE + 19, "#Overlapped date for this product, prices already imported for period")
            as_Err = as_Err & " " & mo_Db.GetFields(ll_Cursor, "PRC_VStart") & " - " & mo_Db.GetFields(ll_Cursor, "PRC_VExp")
        Else
            ImportPrice_CommonInfoCheck = True
        End If
        Call mo_Db.Close(ll_Cursor)
    Else
        as_Request = ls_Request
        ImportPrice_CommonInfoCheck = True
    End If
    
    Exit Function
ErrHandler:
    as_Err = Err.Description
    ImportPrice_CommonInfoCheck = False
End Function

' display standard error message
Public Sub ErrorMessage(ByVal as_Fct As String)
    Dim ls_ErrSource As String
    Dim ls_errDescription As String
    Dim ls_Message As String
    
    ls_ErrSource = as_Fct & SEP1 & Err.Source
    ls_errDescription = Err.Description
    ls_Message = SCREEN_NAME & " exception. Nr:" & Err.Number & ",Desc: " & ls_errDescription & ",Src:" & ls_ErrSource & "@"
    Call mo_Tools.LogMessage(mo_Db, ml_U_Code, SCREEN_NAME, ls_Message, "E")
    Call MsgBox("Error occured, please contact IT. Application will now shutdown." & vbCrLf & ls_ErrSource & vbCrLf & "Description: " & ls_errDescription, vbCritical, App.Title & " " & App.Major & "." & App.Minor & "." & App.Revision)
    End
End Sub

' Standard error handler
Private Sub ErrorHandler(ByVal as_Fct As String)
  
    Call Err.Raise(Err.Number, Me.Name & "." & as_Fct & SEP1 & Err.Source, Err.Description)
End Sub





